/*
 * Decompiled with CFR 0.152.
 */
package com.teachonmars.modules.widget.segmentedProgress;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.teachonmars.modules.widget.segmentedProgress.R;
import com.teachonmars.modules.widget.segmentedProgress.internal.DrawingController;
import com.teachonmars.modules.widget.segmentedProgress.internal.ViewMeasurer;

public class SegmentedProgress
extends View {
    private DrawingController drawingController;
    private ViewMeasurer viewMeasurer;

    public SegmentedProgress(Context context) {
        this(context, null);
    }

    public SegmentedProgress(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.segmentedProgressStyle);
    }

    public SegmentedProgress(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, R.style.SegmentedProgressDefault);
    }

    public SegmentedProgress(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init();
        this.initFromAttrs(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init() {
        this.drawingController = new DrawingController(this);
        this.viewMeasurer = new ViewMeasurer(this, this.drawingController);
    }

    private void initFromAttrs(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SegmentedProgress, defStyleAttr, defStyleRes);
        this.drawingController.loadFromResources(a, this.isInEditMode());
        a.recycle();
    }

    public void setImageDrawable(Drawable drawable) {
        this.drawingController.setImageDrawable(drawable);
    }

    public void setDrawable(@DrawableRes int resId) {
        this.drawingController.setDrawable(resId);
    }

    public void postInvalidate() {
        if (!this.drawingController.isPreventInvalidation()) {
            super.postInvalidate();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Rect bounds = this.viewMeasurer.measure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(bounds.width(), bounds.height());
    }

    public int getSuggestedMinimumHeight() {
        return Math.max(this.drawingController.getMinHeight(), super.getSuggestedMinimumHeight());
    }

    public int getSuggestedMinimumWidth() {
        return Math.max(this.drawingController.getMinWidth(), super.getSuggestedMinimumWidth());
    }

    protected void onDraw(Canvas canvas) {
        this.drawingController.draw(canvas);
    }

    public void setProgress(float progressPercent) {
        this.drawingController.setProgress(progressPercent, true);
        this.invalidate();
    }

    public void initProgress(float progress) {
        this.drawingController.setProgress(progress, false);
    }

    public float getProgress() {
        return this.drawingController.getProgress();
    }

    public void setNbSection(int nbSection) {
        this.drawingController.setNbSection(nbSection);
    }

    public int getShowCount() {
        return this.drawingController.getShowCount();
    }
}

