/*
 * Decompiled with CFR 0.152.
 */
package com.teachonmars.modules.widget.overlapLayout;

import android.graphics.Rect;
import android.support.v4.view.ViewCompat;
import android.view.Gravity;
import android.view.View;
import com.teachonmars.modules.widget.overlapLayout.OverlapLayout;

class ChildLayoutDelegate {
    private final Rect childPosition;
    private final Rect availableSpace;
    private final OverlapLayout parent;
    private int parentHorizontalGravity;
    private int parentVerticalGravity;

    public ChildLayoutDelegate(OverlapLayout overlapLayout) {
        this.parent = overlapLayout;
        this.childPosition = new Rect();
        this.availableSpace = new Rect();
    }

    public void layout(int l, int t, int r, int b) {
        this.initBeforeLayout(l, t, r, b);
        if (this.parent.orientation == 0) {
            this.layoutHorizontal();
        } else {
            this.layoutVertical();
        }
    }

    private void initBeforeLayout(int l, int t, int r, int b) {
        this.availableSpace.set(this.parent.getPaddingLeft(), this.parent.getPaddingTop(), r - l - this.parent.getPaddingRight(), b - t - this.parent.getPaddingBottom());
        this.parentHorizontalGravity = Gravity.getAbsoluteGravity((int)(this.parent.getGravity() & 0x800007), (int)ViewCompat.getLayoutDirection((View)this.parent));
        this.parentVerticalGravity = this.parent.getGravity() & 0x70;
    }

    private void layoutHorizontal() {
        int nbLayouted = 0;
        Rect marginRect = new Rect();
        int count = this.parent.getChildCount();
        for (int pos = 0; pos < count && nbLayouted < this.parent.getMaxChildShowCount(); ++pos) {
            View child = this.parent.getChildAt(pos);
            if (child.getVisibility() == 8) continue;
            this.retrieveChildMargins(child, marginRect);
            this.alignVerticalChild(child, marginRect);
            if (nbLayouted == 0) {
                this.horizontalInitChildPosition(child, marginRect);
            } else {
                this.horizontalPushChildPosition(child, marginRect);
            }
            this.layoutChild(child, this.childPosition, marginRect);
            ++nbLayouted;
        }
    }

    private void alignVerticalChild(View child, Rect marginRect) {
        switch (this.parentVerticalGravity) {
            case 48: {
                this.childPosition.top = this.availableSpace.top;
                this.childPosition.bottom = this.childPosition.top + child.getMeasuredHeight() + marginRect.top + marginRect.bottom;
                break;
            }
            case 80: {
                this.childPosition.bottom = this.availableSpace.bottom;
                this.childPosition.top = this.childPosition.bottom - (child.getMeasuredHeight() + marginRect.top + marginRect.bottom);
                break;
            }
            default: {
                float childHalfHeight = (float)(child.getMeasuredHeight() + marginRect.top + marginRect.bottom) / 2.0f;
                float parentVerticalCenter = this.availableSpace.exactCenterY();
                this.childPosition.top = (int)(parentVerticalCenter - childHalfHeight);
                this.childPosition.bottom = (int)(parentVerticalCenter + childHalfHeight);
            }
        }
    }

    private void horizontalInitChildPosition(View child, Rect marginRect) {
        switch (this.parentHorizontalGravity) {
            case 5: {
                this.childPosition.left = this.availableSpace.right - this.parent.allChildRect.width() + marginRect.left;
                break;
            }
            case 1: 
            case 17: {
                this.childPosition.left = (int)((float)this.availableSpace.left + (float)(this.availableSpace.width() - this.parent.allChildRect.width()) / 2.0f);
                break;
            }
            default: {
                this.childPosition.left = this.availableSpace.left;
            }
        }
        this.childPosition.right = this.childPosition.left + child.getMeasuredWidth() + marginRect.left + marginRect.right;
    }

    private void horizontalPushChildPosition(View child, Rect marginRect) {
        int childWidth = child.getMeasuredWidth();
        this.childPosition.left = (int)((float)this.childPosition.right - this.parent.overlapFactor * (float)childWidth);
        this.childPosition.right = this.childPosition.left + childWidth + marginRect.left + marginRect.right;
    }

    private void layoutVertical() {
        int nbLayouted = 0;
        Rect marginRect = new Rect();
        int count = this.parent.getChildCount();
        for (int pos = 0; pos < count && nbLayouted < this.parent.getMaxChildShowCount(); ++pos) {
            View child = this.parent.getChildAt(pos);
            if (child.getVisibility() == 8) continue;
            this.retrieveChildMargins(child, marginRect);
            this.alignHorizontalChild(child, marginRect);
            if (nbLayouted == 0) {
                this.verticalInitChildPosition(child, marginRect);
            } else {
                this.verticalPushChildPosition(child, marginRect);
            }
            this.layoutChild(child, this.childPosition, marginRect);
            ++nbLayouted;
        }
    }

    private void alignHorizontalChild(View child, Rect marginRect) {
        switch (this.parentHorizontalGravity) {
            case 3: {
                this.childPosition.left = this.availableSpace.left;
                this.childPosition.right = this.childPosition.left + child.getMeasuredWidth() + marginRect.left + marginRect.right;
                break;
            }
            case 5: {
                this.childPosition.right = this.availableSpace.right;
                this.childPosition.left = this.childPosition.right - (child.getMeasuredWidth() + marginRect.left + marginRect.right);
                break;
            }
            default: {
                float childHalfWidth = (float)(child.getMeasuredWidth() + marginRect.left + marginRect.right) / 2.0f;
                float parentHorizontalCenter = this.availableSpace.exactCenterX();
                this.childPosition.left = (int)(parentHorizontalCenter - childHalfWidth);
                this.childPosition.right = (int)(parentHorizontalCenter + childHalfWidth);
            }
        }
    }

    private void verticalInitChildPosition(View child, Rect marginRect) {
        switch (this.parentVerticalGravity) {
            case 80: {
                this.childPosition.top = this.availableSpace.bottom - this.parent.allChildRect.height();
                break;
            }
            case 16: 
            case 17: {
                this.childPosition.top = (int)((float)this.availableSpace.top + (float)(this.availableSpace.height() - this.parent.allChildRect.height()) / 2.0f);
                break;
            }
            default: {
                this.childPosition.top = this.availableSpace.top;
            }
        }
        this.childPosition.bottom = this.childPosition.top + child.getMeasuredHeight() + marginRect.top + marginRect.bottom;
    }

    private void verticalPushChildPosition(View child, Rect marginRect) {
        int childHeight = child.getMeasuredHeight();
        this.childPosition.top = (int)((float)this.childPosition.bottom - (float)childHeight * this.parent.overlapFactor);
        this.childPosition.bottom = this.childPosition.top + childHeight + marginRect.top + marginRect.bottom;
    }

    private void retrieveChildMargins(View child, Rect out) {
        OverlapLayout.LayoutParams lp = (OverlapLayout.LayoutParams)child.getLayoutParams();
        out.set(lp.leftMargin, lp.topMargin, lp.rightMargin, lp.bottomMargin);
    }

    private void layoutChild(View child, Rect childPosition, Rect marginRect) {
        child.layout(childPosition.left + marginRect.left, childPosition.top + marginRect.top, childPosition.right - marginRect.right, childPosition.bottom - marginRect.bottom);
    }
}

