/*
 * Decompiled with CFR 0.152.
 */
package com.teachonmars.modules.widget.overlapLayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.teachonmars.modules.widget.overlapLayout.ChildLayoutDelegate;
import com.teachonmars.modules.widget.overlapLayout.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class OverlapLayout
extends ViewGroup {
    int orientation;
    float overlapFactor;
    public Rect allChildRect = new Rect();
    private ChildLayoutDelegate childLayoutDelegate;
    private int maxChildShowCount;
    private int gravity;
    private int renderOrder;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int BOTTOM_TO_TOP = 0;
    public static final int TOP_TO_BOTTOM = 1;

    public OverlapLayout(Context context) {
        this(context, null);
    }

    public OverlapLayout(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.overlapLayoutStyle);
    }

    public OverlapLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, R.style.OverlapLayoutDefault);
    }

    public OverlapLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.OverlapLayout, defStyleAttr, defStyleRes);
            this.initConfig(a);
            a.recycle();
        }
        this.init();
    }

    private void initConfig(TypedArray a) {
        this.maxChildShowCount = a.getInteger(R.styleable.OverlapLayout_maxChildShowCount, 0);
        this.gravity = a.getInt(R.styleable.OverlapLayout_android_gravity, 8388629);
        this.orientation = a.getInt(R.styleable.OverlapLayout_android_orientation, 0);
        this.overlapFactor = a.getFraction(R.styleable.OverlapLayout_overlapFactor, 1, 1, 1.0f);
        this.renderOrder = a.getInt(R.styleable.OverlapLayout_renderOrder, 1);
    }

    private void init() {
        this.childLayoutDelegate = new ChildLayoutDelegate(this);
        if (this.renderOrder == 1) {
            this.setChildrenDrawingOrderEnabled(true);
        }
    }

    public int getMaxChildShowCount() {
        return this.maxChildShowCount;
    }

    public int getGravity() {
        return this.gravity;
    }

    public void setGravity(int gravity) {
        this.gravity = gravity;
        this.requestLayout();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.childLayoutDelegate.layout(l, t, r, b);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int horizontalPadding = ViewCompat.getPaddingStart((View)this) + ViewCompat.getPaddingEnd((View)this);
        int verticalPadding = this.getPaddingTop() + this.getPaddingBottom();
        int nbMeasured = 0;
        this.allChildRect.setEmpty();
        int count = this.getChildCount();
        for (int pos = 0; pos < count && nbMeasured < this.maxChildShowCount; ++pos) {
            View child = this.getChildAt(pos);
            if (child.getVisibility() == 8) continue;
            this.measureChildWithMargins(child, widthMeasureSpec, this.allChildRect.width(), heightMeasureSpec, this.allChildRect.height());
            this.updateAllChildBounds(child.getMeasuredWidth(), child.getMeasuredHeight());
            ++nbMeasured;
        }
        this.setMeasuredDimension(OverlapLayout.resolveSize((int)(Math.max(this.allChildRect.width(), this.getSuggestedMinimumWidth()) + horizontalPadding), (int)widthMeasureSpec), OverlapLayout.resolveSize((int)(Math.max(this.allChildRect.height(), this.getSuggestedMinimumHeight()) + verticalPadding), (int)heightMeasureSpec));
    }

    private void updateAllChildBounds(int childWidth, int childHeight) {
        if (this.orientation == 0) {
            this.allChildRect.set(0, 0, this.allChildRect.isEmpty() ? childWidth : (int)((float)this.allChildRect.width() + this.overlapFactor * (float)childWidth), Math.max(this.allChildRect.height(), childHeight));
        } else {
            this.allChildRect.set(0, 0, Math.max(this.allChildRect.width(), childWidth), this.allChildRect.isEmpty() ? childHeight : (int)((float)this.allChildRect.height() + this.overlapFactor * (float)childHeight));
        }
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        if (this.renderOrder == 0) {
            return super.getChildDrawingOrder(childCount, i);
        }
        return childCount - i - 1;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams lp) {
        return lp instanceof LayoutParams;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        if (lp instanceof LayoutParams || lp instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
        }
        return new LayoutParams(lp);
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RenderOrder {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OrientationMode {
    }
}

