/*
 * Decompiled with CFR 0.152.
 */
package com.teachonmars.modules.widget.overlapLayout;

import android.graphics.Rect;
import android.support.v4.view.ViewCompat;
import android.view.Gravity;
import android.view.View;
import com.teachonmars.modules.widget.overlapLayout.OverlapLayout;

class ChildLayoutDelegate {
    private final Rect childPosition;
    private final Rect availableSpace;
    private final OverlapLayout parent;
    private int layoutDirection;
    private int parentHorizontalGravity;
    private int parentVerticalGravity;

    public ChildLayoutDelegate(OverlapLayout overlapLayout) {
        this.parent = overlapLayout;
        this.childPosition = new Rect();
        this.availableSpace = new Rect();
    }

    public void layout(int l, int t, int r, int b) {
        this.initBeforeLayout(l, t, r, b);
        if (this.parent.orientation == 0) {
            this.layoutHorizontal();
        } else {
            this.layoutVertical();
        }
    }

    private void layoutHorizontal() {
        int nbLayouted = 0;
        int count = this.parent.getChildCount();
        for (int pos = 0; pos < count && nbLayouted < this.parent.getMaxChildShowCount(); ++pos) {
            View child = this.parent.getChildAt(pos);
            if (child.getVisibility() == 8) continue;
            this.alignVerticalChild(child);
            if (nbLayouted == 0) {
                this.horizontalInitChildPosition(child);
            } else {
                int childWidth = child.getMeasuredWidth();
                this.childPosition.right = (int)((float)this.childPosition.right + (float)childWidth * this.parent.overlapFactor);
                this.childPosition.left = this.childPosition.right - childWidth;
            }
            child.layout(this.childPosition.left, this.childPosition.top, this.childPosition.right, this.childPosition.bottom);
            ++nbLayouted;
        }
    }

    private void alignVerticalChild(View child) {
        switch (this.parentVerticalGravity) {
            case 48: {
                this.childPosition.top = this.availableSpace.top;
                this.childPosition.bottom = this.availableSpace.top + child.getMeasuredHeight();
                break;
            }
            case 80: {
                this.childPosition.top = this.availableSpace.bottom - child.getMeasuredHeight();
                this.childPosition.bottom = this.availableSpace.bottom;
                break;
            }
            default: {
                float childHalfHeight = (float)child.getMeasuredHeight() / 2.0f;
                float parentVerticalCenter = this.availableSpace.exactCenterY();
                this.childPosition.top = (int)(parentVerticalCenter - childHalfHeight);
                this.childPosition.bottom = (int)(parentVerticalCenter + childHalfHeight);
            }
        }
    }

    private void horizontalInitChildPosition(View child) {
        switch (this.parentHorizontalGravity) {
            case 5: {
                this.childPosition.left = this.availableSpace.right - this.parent.allChildRect.width();
                this.childPosition.right = this.childPosition.left + child.getMeasuredWidth();
                break;
            }
            default: {
                this.childPosition.left = this.availableSpace.left;
                this.childPosition.right = this.childPosition.left + child.getMeasuredWidth();
            }
        }
    }

    private void layoutVertical() {
        int nbLayouted = 0;
        int count = this.parent.getChildCount();
        for (int pos = 0; pos < count && nbLayouted < this.parent.getMaxChildShowCount(); ++pos) {
            View child = this.parent.getChildAt(pos);
            if (child.getVisibility() == 8) continue;
            this.alignHorizontalChild(child);
            if (nbLayouted == 0) {
                this.verticalInitChildPosition(child);
            } else {
                int childHeight = child.getMeasuredHeight();
                this.childPosition.bottom = (int)((float)this.childPosition.bottom + (float)childHeight * this.parent.overlapFactor);
                this.childPosition.top = this.childPosition.bottom - childHeight;
            }
            child.layout(this.childPosition.left, this.childPosition.top, this.childPosition.right, this.childPosition.bottom);
            ++nbLayouted;
        }
    }

    private void verticalInitChildPosition(View child) {
        switch (this.parentVerticalGravity) {
            case 80: {
                this.childPosition.top = this.availableSpace.bottom - this.parent.allChildRect.height();
                this.childPosition.bottom = this.childPosition.top + child.getMeasuredHeight();
                break;
            }
            default: {
                this.childPosition.top = this.availableSpace.top;
                this.childPosition.bottom = this.availableSpace.top + child.getMeasuredHeight();
            }
        }
    }

    private void alignHorizontalChild(View child) {
        switch (this.parentHorizontalGravity) {
            case 3: {
                this.childPosition.left = this.availableSpace.left;
                this.childPosition.right = this.availableSpace.left + child.getMeasuredWidth();
                break;
            }
            case 5: {
                this.childPosition.left = this.availableSpace.right - child.getMeasuredWidth();
                this.childPosition.right = this.availableSpace.right;
                break;
            }
            default: {
                float childHalfWidth = (float)child.getMeasuredWidth() / 2.0f;
                float parentHorizontalCenter = this.availableSpace.exactCenterX();
                this.childPosition.left = (int)(parentHorizontalCenter - childHalfWidth);
                this.childPosition.right = (int)(parentHorizontalCenter + childHalfWidth);
            }
        }
    }

    private void initBeforeLayout(int l, int t, int r, int b) {
        this.layoutDirection = ViewCompat.getLayoutDirection((View)this.parent);
        this.availableSpace.set(this.parent.getPaddingLeft(), this.parent.getPaddingTop(), r - l - this.parent.getPaddingRight(), b - t - this.parent.getPaddingBottom());
        this.parentHorizontalGravity = Gravity.getAbsoluteGravity((int)(this.parent.getGravity() & 0x800007), (int)this.layoutDirection);
        this.parentVerticalGravity = this.parent.getGravity() & 0x70;
    }
}

