/*
 * Decompiled with CFR 0.152.
 */
package com.teachonmars.modules.widget.circularImageView;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.View;
import com.teachonmars.modules.widget.circularImageView.CustomDrawable;
import com.teachonmars.modules.widget.circularImageView.R;

public class CircularImageView
extends AppCompatImageView {
    private Path circlePath;
    private Path borderPath;
    private Paint borderPaint;
    private int canvasBeforeDrawState;
    private int gapSize;
    private int gapColor;
    private int borderSize;
    private int borderColor;
    private Drawable baseDrawable;
    private boolean needInsetDrawable;

    public CircularImageView(Context context) {
        this(context, null);
    }

    public CircularImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircularImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, R.style.CircularImageViewDefault);
    }

    public CircularImageView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.initFromAttrs(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void initFromAttrs(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircularImageView, defStyleAttr, defStyleRes);
        this.extractGapAndBorderShader(a);
        a.recycle();
    }

    public void setGapSize(int gapSize) {
        this.gapSize = gapSize;
        this.updateDrawable();
        this.updateBounds();
    }

    public void setGapColor(int gapColor) {
        this.gapColor = gapColor;
        this.updateBounds();
    }

    public void setBorderSize(int borderSize) {
        this.borderSize = borderSize;
        this.updateDrawable();
        this.updateBounds();
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        this.updateBounds();
    }

    public void setNeedInsetDrawable(boolean needInsetDrawable) {
        this.needInsetDrawable = needInsetDrawable;
        this.updateDrawable();
    }

    private void extractGapAndBorderShader(TypedArray a) {
        this.gapSize = a.getDimensionPixelSize(R.styleable.CircularImageView_gapSize, 0);
        this.borderSize = a.getDimensionPixelSize(R.styleable.CircularImageView_borderSize, 0);
        this.gapColor = a.getColor(R.styleable.CircularImageView_gapColor, 0);
        this.borderColor = a.getColor(R.styleable.CircularImageView_borderColor, 0);
        this.needInsetDrawable = a.getBoolean(R.styleable.CircularImageView_needInsetDrawable, false);
        this.updateDrawable();
    }

    private void init() {
        this.circlePath = new Path();
        this.borderPath = new Path();
        this.borderPaint = new Paint(1);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.updateBounds();
    }

    private void updateBounds() {
        int measuredWidth = this.getMeasuredWidth();
        int measuredHeight = this.getMeasuredHeight();
        if (measuredWidth > 0 && measuredHeight > 0) {
            this.setDrawBounds(measuredWidth - ViewCompat.getPaddingStart((View)this) - ViewCompat.getPaddingEnd((View)this), measuredHeight - this.getPaddingTop() - this.getPaddingBottom());
        }
    }

    private void setDrawBounds(int width, int height) {
        float w = (float)width / 2.0f;
        float h = (float)height / 2.0f;
        float radius = Math.min(w, h);
        this.circlePath.reset();
        this.circlePath.addCircle(w, h, radius - (float)(this.borderSize + this.gapSize), Path.Direction.CW);
        this.borderPath.reset();
        this.borderPath.addCircle(w, h, radius, Path.Direction.CW);
        this.borderPaint.setDither(true);
        this.borderPaint.setShader((Shader)this.buildBorderShader(w, h, radius));
    }

    private RadialGradient buildBorderShader(float xCenter, float yCenter, float radius) {
        float edgeAdjuster = 1.0f / radius;
        float centerEnd = (radius - (float)(this.gapSize + this.borderSize)) / radius;
        float gapStart = centerEnd + edgeAdjuster;
        float gapEnd = centerEnd + (float)this.gapSize / radius;
        float borderStart = gapEnd + edgeAdjuster;
        int[] colors = new int[]{this.noAlpha(this.gapColor), this.noAlpha(this.gapColor), this.gapColor, this.gapColor, this.borderColor, this.borderColor};
        float[] positions = new float[]{0.0f, centerEnd - edgeAdjuster, gapStart, gapEnd, borderStart, 1.0f};
        return new RadialGradient(xCenter, yCenter, radius, colors, positions, Shader.TileMode.CLAMP);
    }

    private int noAlpha(int color) {
        return Color.argb((int)0, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
    }

    public void draw(Canvas canvas) {
        this.canvasBeforeDrawState = canvas.save();
        canvas.clipPath(this.circlePath);
        super.draw(canvas);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.restoreToCount(this.canvasBeforeDrawState);
        canvas.drawPath(this.borderPath, this.borderPaint);
    }

    public void setImageDrawable(@Nullable Drawable baseDrawable) {
        this.baseDrawable = baseDrawable;
        this.updateDrawable();
    }

    private void updateDrawable() {
        if (this.baseDrawable != null && this.needInsetDrawable && (this.gapSize != 0 || this.borderSize != 0)) {
            int inset = this.gapSize + this.borderSize;
            super.setImageDrawable((Drawable)new CustomDrawable(this.baseDrawable, inset));
        } else {
            super.setImageDrawable(this.baseDrawable);
        }
    }
}

