/*
 * Decompiled with CFR 0.152.
 */
package com.teachonmars.modules.appLife.internal;

import android.app.Activity;
import com.teachonmars.modules.appLife.listeners.ActivitySpyBase;
import java.lang.ref.WeakReference;
import java.util.Hashtable;

class WeakableList<T extends ActivitySpyBase> {
    private Hashtable<Integer, WeakReference<T>> weakData = new Hashtable();
    private Hashtable<Integer, T> data = new Hashtable();

    WeakableList() {
    }

    void add(T listener, boolean hardRef) {
        if (listener != null) {
            if (hardRef) {
                this.data.put(listener.hashCode(), listener);
            } else {
                this.weakData.put(listener.hashCode(), new WeakReference<T>(listener));
            }
        }
    }

    void remove(ActivitySpyBase listener) {
        if (listener != null) {
            if (this.data.get(listener.hashCode()) == listener) {
                this.data.remove(listener.hashCode());
            } else {
                this.weakData.remove(listener.hashCode());
            }
        }
    }

    void iterCreation(Activity activity) {
        for (WeakReference<T> listenerRef : this.weakData.values()) {
            ActivitySpyBase listener = (ActivitySpyBase)listenerRef.get();
            if (listener == null) continue;
            listener.onCreate(activity);
        }
        for (ActivitySpyBase listener : this.data.values()) {
            listener.onCreate(activity);
        }
    }

    void iterDestruction(Activity activity) {
        for (WeakReference<T> listenerRef : this.weakData.values()) {
            ActivitySpyBase listener = (ActivitySpyBase)listenerRef.get();
            if (listener == null) continue;
            listener.onDestroy(activity);
        }
        for (ActivitySpyBase listener : this.data.values()) {
            listener.onDestroy(activity);
        }
    }

    void iterStart(Activity activity) {
        for (WeakReference<T> listenerRef : this.weakData.values()) {
            ActivitySpyBase listener = (ActivitySpyBase)listenerRef.get();
            if (listener == null) continue;
            listener.onStart(activity);
        }
        for (ActivitySpyBase listener : this.data.values()) {
            listener.onStart(activity);
        }
    }

    void iterStop(Activity activity) {
        for (WeakReference<T> listenerRef : this.weakData.values()) {
            ActivitySpyBase listener = (ActivitySpyBase)listenerRef.get();
            if (listener == null) continue;
            listener.onStop(activity);
        }
        for (ActivitySpyBase listener : this.data.values()) {
            listener.onStop(activity);
        }
    }

    void iterResume(Activity activity) {
        for (WeakReference<T> listenerRef : this.weakData.values()) {
            ActivitySpyBase listener = (ActivitySpyBase)listenerRef.get();
            if (listener == null) continue;
            listener.onResume(activity);
        }
        for (ActivitySpyBase listener : this.data.values()) {
            listener.onResume(activity);
        }
    }

    void iterPause(Activity activity) {
        for (WeakReference<T> listenerRef : this.weakData.values()) {
            ActivitySpyBase listener = (ActivitySpyBase)listenerRef.get();
            if (listener == null) continue;
            listener.onPause(activity);
        }
        for (ActivitySpyBase listener : this.data.values()) {
            listener.onPause(activity);
        }
    }
}

