/*
 * Decompiled with CFR 0.152.
 */
package com.teachonmars.modules.appLife.internal;

import android.app.Activity;
import android.app.Application;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import com.teachonmars.modules.appLife.internal.WeakableList;
import com.teachonmars.modules.appLife.listeners.ActivitySpyBase;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.ListIterator;

public final class AppSpy
implements Application.ActivityLifecycleCallbacks {
    private LinkedHashMap<Integer, WeakReference<Activity>> activityStack = new LinkedHashMap();
    private WeakableList<ActivitySpyBase> activitiesLifeListeners = new WeakableList();

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.bindActivity(activity);
        this.activitiesLifeListeners.iterCreation(activity);
    }

    public void onActivityStarted(Activity activity) {
        this.activitiesLifeListeners.iterStart(activity);
    }

    public void onActivityResumed(Activity activity) {
        this.activitiesLifeListeners.iterResume(activity);
    }

    public void onActivityPaused(Activity activity) {
        this.activitiesLifeListeners.iterPause(activity);
    }

    public void onActivityStopped(Activity activity) {
        this.activitiesLifeListeners.iterStop(activity);
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.unbindActivity(activity);
        this.activitiesLifeListeners.iterDestruction(activity);
    }

    @Nullable
    public Activity tryGetCurrentActivity() {
        Collection<WeakReference<Activity>> values = this.activityStack.values();
        ListIterator<WeakReference<Activity>> weakReferenceListIterator = new ArrayList<WeakReference<Activity>>(values).listIterator(values.size());
        while (weakReferenceListIterator.hasPrevious()) {
            WeakReference<Activity> activityRef = weakReferenceListIterator.previous();
            Activity candidate = this.ensureActivityStillExist((Activity)activityRef.get());
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    private Activity ensureActivityStillExist(Activity activity) {
        if (activity != null && Build.VERSION.SDK_INT > 17 && activity.isDestroyed()) {
            return null;
        }
        return activity;
    }

    private void bindActivity(Activity activity) {
        if (activity != null) {
            this.activityStack.put(activity.hashCode(), new WeakReference<Activity>(activity));
        }
    }

    private void unbindActivity(Activity activity) {
        if (activity != null) {
            this.activityStack.remove(activity.hashCode());
        }
    }

    public boolean isStillAlive(int activityHash) {
        return this.ensureActivityStillExist((Activity)this.activityStack.get(activityHash).get()) != null;
    }

    public void registerListener(ActivitySpyBase listener, boolean hardRef) {
        if (listener != null) {
            this.activitiesLifeListeners.add(listener, hardRef);
        }
    }

    public void unregisterListener(ActivitySpyBase listener) {
        if (listener != null) {
            this.activitiesLifeListeners.remove(listener);
        }
    }
}

