/*
 * Decompiled with CFR 0.152.
 */
package com.teachonmars.modules.appLife.internal;

import android.app.Activity;
import com.teachonmars.modules.appLife.listeners.ActivitySpyBase;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

class WeakableArrayList<T extends ActivitySpyBase> {
    private ArrayList<WeakReference<T>> weakData = new ArrayList();
    private ArrayList<T> data = new ArrayList();

    WeakableArrayList() {
    }

    void add(T listener, boolean hardRef) {
        if (listener != null) {
            if (hardRef) {
                this.data.add(listener.hashCode(), listener);
            } else {
                this.weakData.add(listener.hashCode(), new WeakReference<T>(listener));
            }
        }
    }

    void remove(ActivitySpyBase listener) {
        if (listener != null) {
            if (this.data.get(listener.hashCode()) == listener) {
                this.data.remove(listener.hashCode());
            } else {
                this.weakData.remove(listener.hashCode());
            }
        }
    }

    void iterCreation(Activity activity) {
        for (WeakReference<T> listenerRef : this.weakData) {
            ActivitySpyBase listener = (ActivitySpyBase)listenerRef.get();
            if (listener == null) continue;
            listener.onCreate(activity);
        }
        for (ActivitySpyBase listener : this.data) {
            listener.onCreate(activity);
        }
    }

    void iterDestruction(Activity activity) {
        for (WeakReference<T> listenerRef : this.weakData) {
            ActivitySpyBase listener = (ActivitySpyBase)listenerRef.get();
            if (listener == null) continue;
            listener.onDestroy(activity);
        }
        for (ActivitySpyBase listener : this.data) {
            listener.onDestroy(activity);
        }
    }

    void iterStart(Activity activity) {
        for (WeakReference<T> listenerRef : this.weakData) {
            ActivitySpyBase listener = (ActivitySpyBase)listenerRef.get();
            if (listener == null) continue;
            listener.onStart(activity);
        }
        for (ActivitySpyBase listener : this.data) {
            listener.onStart(activity);
        }
    }

    void iterStop(Activity activity) {
        for (WeakReference<T> listenerRef : this.weakData) {
            ActivitySpyBase listener = (ActivitySpyBase)listenerRef.get();
            if (listener == null) continue;
            listener.onStop(activity);
        }
        for (ActivitySpyBase listener : this.data) {
            listener.onStop(activity);
        }
    }

    void iterResume(Activity activity) {
        for (WeakReference<T> listenerRef : this.weakData) {
            ActivitySpyBase listener = (ActivitySpyBase)listenerRef.get();
            if (listener == null) continue;
            listener.onResume(activity);
        }
        for (ActivitySpyBase listener : this.data) {
            listener.onResume(activity);
        }
    }

    void iterPause(Activity activity) {
        for (WeakReference<T> listenerRef : this.weakData) {
            ActivitySpyBase listener = (ActivitySpyBase)listenerRef.get();
            if (listener == null) continue;
            listener.onPause(activity);
        }
        for (ActivitySpyBase listener : this.data) {
            listener.onPause(activity);
        }
    }
}

