/*
 * Decompiled with CFR 0.152.
 */
package com.teachonmars.modules.appLife.internal;

import android.app.Activity;
import android.app.Application;
import android.os.Build;
import android.os.Bundle;
import com.teachonmars.modules.appLife.internal.WeakableArrayList;
import com.teachonmars.modules.appLife.listeners.ActivityActiveSpy;
import com.teachonmars.modules.appLife.listeners.ActivityBaseSpy;
import com.teachonmars.modules.appLife.listeners.ActivityCreationSpy;
import com.teachonmars.modules.appLife.listeners.ActivityVisibleSpy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.ListIterator;

public class AppSpy
implements Application.ActivityLifecycleCallbacks {
    private LinkedHashMap<Integer, WeakReference<Activity>> activityStack = new LinkedHashMap();
    private WeakableArrayList<ActivityCreationSpy> creationActivityListeners = new WeakableArrayList();
    private WeakableArrayList<ActivityVisibleSpy> visibleActivityListeners = new WeakableArrayList();
    private WeakableArrayList<ActivityActiveSpy> activeActivityListeners = new WeakableArrayList();
    private WeakableArrayList<ActivityBaseSpy> wholeActivityLifeListeners = new WeakableArrayList();

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.bindActivity(activity);
        this.creationActivityListeners.iterCreation(activity);
        this.wholeActivityLifeListeners.iterCreation(activity);
    }

    public void onActivityStarted(Activity activity) {
        this.visibleActivityListeners.iterStart(activity);
        this.wholeActivityLifeListeners.iterStart(activity);
    }

    public void onActivityResumed(Activity activity) {
        this.activeActivityListeners.iterResume(activity);
        this.wholeActivityLifeListeners.iterResume(activity);
    }

    public void onActivityPaused(Activity activity) {
        this.activeActivityListeners.iterPause(activity);
        this.wholeActivityLifeListeners.iterPause(activity);
    }

    public void onActivityStopped(Activity activity) {
        this.visibleActivityListeners.iterStop(activity);
        this.wholeActivityLifeListeners.iterStop(activity);
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.unbindActivity(activity);
        this.creationActivityListeners.iterDestruction(activity);
        this.wholeActivityLifeListeners.iterDestruction(activity);
    }

    public Activity tryGetCurrentActivity() {
        Collection<WeakReference<Activity>> values = this.activityStack.values();
        ListIterator<WeakReference<Activity>> weakReferenceListIterator = new ArrayList<WeakReference<Activity>>(values).listIterator(values.size());
        while (weakReferenceListIterator.hasPrevious()) {
            WeakReference<Activity> activityRef = weakReferenceListIterator.previous();
            Activity candidate = this.ensureActivityStillExist((Activity)activityRef.get());
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    private Activity ensureActivityStillExist(Activity activity) {
        if (activity != null && Build.VERSION.SDK_INT > 17 && activity.isDestroyed()) {
            return null;
        }
        return activity;
    }

    private void bindActivity(Activity activity) {
        if (activity != null) {
            this.activityStack.put(activity.hashCode(), new WeakReference<Activity>(activity));
        }
    }

    private void unbindActivity(Activity activity) {
        if (activity != null) {
            this.activityStack.remove(activity.hashCode());
        }
    }

    public boolean isStillAlive(int activityHash) {
        return this.activityStack.get(activityHash).get() != null;
    }

    public void registerListener(ActivityBaseSpy listener, boolean hardRef) {
        if (listener != null) {
            if (listener instanceof ActivityCreationSpy) {
                this.creationActivityListeners.add((ActivityCreationSpy)listener, hardRef);
            } else if (listener instanceof ActivityVisibleSpy) {
                this.visibleActivityListeners.add((ActivityVisibleSpy)listener, hardRef);
            } else if (listener instanceof ActivityActiveSpy) {
                this.activeActivityListeners.add((ActivityActiveSpy)listener, hardRef);
            } else {
                this.wholeActivityLifeListeners.add(listener, hardRef);
            }
        }
    }

    public void unregisterListener(ActivityBaseSpy listener) {
        if (listener != null) {
            if (listener instanceof ActivityCreationSpy) {
                this.creationActivityListeners.remove(listener);
            } else if (listener instanceof ActivityVisibleSpy) {
                this.visibleActivityListeners.remove(listener);
            } else if (listener instanceof ActivityActiveSpy) {
                this.activeActivityListeners.remove(listener);
            } else {
                this.wholeActivityLifeListeners.remove(listener);
            }
        }
    }
}

