/*
 * Decompiled with CFR 0.152.
 */
package com.tbuonomo.viewpagerdotsindicator;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.StyleableRes;
import androidx.viewpager.widget.ViewPager;
import androidx.viewpager2.widget.ViewPager2;
import com.tbuonomo.viewpagerdotsindicator.ExtensionsKt;
import com.tbuonomo.viewpagerdotsindicator.OnPageChangeListenerHelper;
import com.tbuonomo.viewpagerdotsindicator.R;
import com.tbuonomo.viewpagerdotsindicator.attacher.ViewPager2Attacher;
import com.tbuonomo.viewpagerdotsindicator.attacher.ViewPagerAttacher;
import java.util.ArrayList;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0010\b&\u0018\u0000 T2\u00020\u0001:\u0003TUVB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0007H&J\u0010\u00102\u001a\u0002002\u0006\u00103\u001a\u00020\u0007H\u0004J\u000e\u00104\u001a\u0002002\u0006\u00105\u001a\u000206J\u000e\u00104\u001a\u0002002\u0006\u00107\u001a\u000208J\b\u00109\u001a\u00020:H&J\u0010\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0007H\u0004J\u0010\u0010=\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u001aH\u0004J\b\u0010>\u001a\u000200H\u0014J0\u0010?\u001a\u0002002\u0006\u0010@\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020\u00072\u0006\u0010B\u001a\u00020\u00072\u0006\u0010C\u001a\u00020\u00072\u0006\u0010D\u001a\u00020\u0007H\u0014J\u0012\u0010E\u001a\u0002002\b\u0010F\u001a\u0004\u0018\u00010GH\u0014J\u0010\u0010H\u001a\u0002002\u0006\u00101\u001a\u00020\u0007H&J\u0006\u0010I\u001a\u000200J\b\u0010J\u001a\u000200H\u0004J\b\u0010K\u001a\u000200H\u0002J\b\u0010L\u001a\u000200H\u0002J\b\u0010M\u001a\u000200H\u0002J\b\u0010N\u001a\u000200H&J\u0010\u0010O\u001a\u0002002\u0006\u00103\u001a\u00020\u0007H\u0002J\u0010\u0010P\u001a\u0002002\u0006\u0010Q\u001a\u00020\u0007H\u0007J\u0010\u0010R\u001a\u0002002\u0006\u00105\u001a\u000206H\u0007J\u0010\u0010S\u001a\u0002002\u0006\u00107\u001a\u000208H\u0007R \u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u001aX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u001a\u0010\"\u001a\u00020\u001aX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001c\"\u0004\b$\u0010\u001eR\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0012\u0010+\u001a\u00020,X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006W"}, d2={"Lcom/tbuonomo/viewpagerdotsindicator/BaseDotsIndicator;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "dots", "Ljava/util/ArrayList;", "Landroid/widget/ImageView;", "Lkotlin/collections/ArrayList;", "dotsClickable", "", "getDotsClickable", "()Z", "setDotsClickable", "(Z)V", "value", "dotsColor", "getDotsColor", "()I", "setDotsColor", "(I)V", "dotsCornerRadius", "", "getDotsCornerRadius", "()F", "setDotsCornerRadius", "(F)V", "dotsSize", "getDotsSize", "setDotsSize", "dotsSpacing", "getDotsSpacing", "setDotsSpacing", "pager", "Lcom/tbuonomo/viewpagerdotsindicator/BaseDotsIndicator$Pager;", "getPager", "()Lcom/tbuonomo/viewpagerdotsindicator/BaseDotsIndicator$Pager;", "setPager", "(Lcom/tbuonomo/viewpagerdotsindicator/BaseDotsIndicator$Pager;)V", "type", "Lcom/tbuonomo/viewpagerdotsindicator/BaseDotsIndicator$Type;", "getType", "()Lcom/tbuonomo/viewpagerdotsindicator/BaseDotsIndicator$Type;", "addDot", "", "index", "addDots", "count", "attachTo", "viewPager", "Landroidx/viewpager/widget/ViewPager;", "viewPager2", "Landroidx/viewpager2/widget/ViewPager2;", "buildOnPageChangedListener", "Lcom/tbuonomo/viewpagerdotsindicator/OnPageChangeListenerHelper;", "dpToPx", "dp", "dpToPxF", "onAttachedToWindow", "onLayout", "changed", "left", "top", "right", "bottom", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "refreshDotColor", "refreshDots", "refreshDotsColors", "refreshDotsCount", "refreshDotsSize", "refreshOnPageChangedListener", "removeDot", "removeDots", "setPointsColor", "color", "setViewPager", "setViewPager2", "Companion", "Pager", "Type", "viewpagerdotsindicator_debug"})
public abstract class BaseDotsIndicator
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    protected final ArrayList<ImageView> dots;
    private boolean dotsClickable;
    private int dotsColor;
    private float dotsSize;
    private float dotsCornerRadius;
    private float dotsSpacing;
    @Nullable
    private Pager pager;
    public static final int DEFAULT_POINT_COLOR = -16711681;

    @JvmOverloads
    public BaseDotsIndicator(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.dots = new ArrayList();
        this.dotsClickable = true;
        this.dotsColor = -16711681;
        this.dotsSize = this.dpToPxF(this.getType().getDefaultSize());
        this.dotsCornerRadius = this.dotsSize / 2.0f;
        this.dotsSpacing = this.dpToPxF(this.getType().getDefaultSpacing());
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, this.getType().getStyleableId());
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026(attrs, type.styleableId)");
            TypedArray a = typedArray;
            this.setDotsColor(a.getColor(this.getType().getDotsColorId(), -16711681));
            this.dotsSize = a.getDimension(this.getType().getDotsSizeId(), this.dotsSize);
            this.dotsCornerRadius = a.getDimension(this.getType().getDotsCornerRadiusId(), this.dotsCornerRadius);
            this.dotsSpacing = a.getDimension(this.getType().getDotsSpacingId(), this.dotsSpacing);
            this.dotsClickable = a.getBoolean(this.getType().getDotsClickableId(), true);
            a.recycle();
        }
    }

    public /* synthetic */ BaseDotsIndicator(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final boolean getDotsClickable() {
        return this.dotsClickable;
    }

    public final void setDotsClickable(boolean bl) {
        this.dotsClickable = bl;
    }

    public final int getDotsColor() {
        return this.dotsColor;
    }

    public final void setDotsColor(int value) {
        this.dotsColor = value;
        this.refreshDotsColors();
    }

    protected final float getDotsSize() {
        return this.dotsSize;
    }

    protected final void setDotsSize(float f) {
        this.dotsSize = f;
    }

    protected final float getDotsCornerRadius() {
        return this.dotsCornerRadius;
    }

    protected final void setDotsCornerRadius(float f) {
        this.dotsCornerRadius = f;
    }

    protected final float getDotsSpacing() {
        return this.dotsSpacing;
    }

    protected final void setDotsSpacing(float f) {
        this.dotsSpacing = f;
    }

    @Nullable
    public final Pager getPager() {
        return this.pager;
    }

    public final void setPager(@Nullable Pager pager) {
        this.pager = pager;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.post(() -> BaseDotsIndicator.onAttachedToWindow$lambda-0(this));
    }

    private final void refreshDotsCount() {
        int n = this.dots.size();
        Pager pager = this.pager;
        Intrinsics.checkNotNull((Object)pager);
        if (n < pager.getCount()) {
            Pager pager2 = this.pager;
            Intrinsics.checkNotNull((Object)pager2);
            this.addDots(pager2.getCount() - this.dots.size());
        } else {
            int n2 = this.dots.size();
            Pager pager3 = this.pager;
            Intrinsics.checkNotNull((Object)pager3);
            if (n2 > pager3.getCount()) {
                int n3 = this.dots.size();
                Pager pager4 = this.pager;
                Intrinsics.checkNotNull((Object)pager4);
                this.removeDots(n3 - pager4.getCount());
            }
        }
    }

    protected final void refreshDotsColors() {
        int n = this.dots.size();
        for (int i = 0; i < n; ++i) {
            this.refreshDotColor(i);
        }
    }

    protected final int dpToPx(int dp) {
        return (int)(this.getContext().getResources().getDisplayMetrics().density * (float)dp);
    }

    protected final float dpToPxF(float dp) {
        return this.getContext().getResources().getDisplayMetrics().density * dp;
    }

    protected final void addDots(int count) {
        for (int i = 0; i < count; ++i) {
            this.addDot(i);
        }
    }

    private final void removeDots(int count) {
        for (int i = 0; i < count; ++i) {
            this.removeDot();
        }
    }

    public final void refreshDots() {
        if (this.pager == null) {
            return;
        }
        this.post(() -> BaseDotsIndicator.refreshDots$lambda-1(this));
    }

    private final void refreshOnPageChangedListener() {
        Pager pager = this.pager;
        Intrinsics.checkNotNull((Object)pager);
        if (pager.isNotEmpty()) {
            Pager pager2 = this.pager;
            Intrinsics.checkNotNull((Object)pager2);
            pager2.removeOnPageChangeListener();
            OnPageChangeListenerHelper onPageChangeListenerHelper = this.buildOnPageChangedListener();
            Pager pager3 = this.pager;
            Intrinsics.checkNotNull((Object)pager3);
            pager3.addOnPageChangeListener(onPageChangeListenerHelper);
            Pager pager4 = this.pager;
            Intrinsics.checkNotNull((Object)pager4);
            onPageChangeListenerHelper.onPageScrolled(pager4.getCurrentItem(), 0.0f);
        }
    }

    private final void refreshDotsSize() {
        Iterable $this$forEach$iv = this.dots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ImageView it = (ImageView)element$iv;
            boolean bl = false;
            ExtensionsKt.setWidth((View)it, (int)this.dotsSize);
        }
    }

    public abstract void refreshDotColor(int var1);

    public abstract void addDot(int var1);

    public abstract void removeDot();

    @NotNull
    public abstract OnPageChangeListenerHelper buildOnPageChangedListener();

    @NotNull
    public abstract Type getType();

    @Deprecated(message="Use setDotsColors(color) instead", replaceWith=@ReplaceWith(expression="setDotsColors(color)", imports={}))
    public final void setPointsColor(int color) {
        this.setDotsColor(color);
        this.refreshDotsColors();
    }

    @Deprecated(message="Use attachTo(viewPager) instead", replaceWith=@ReplaceWith(expression="attachTo(viewPager)", imports={}))
    public final void setViewPager(@NotNull ViewPager viewPager) {
        Intrinsics.checkNotNullParameter((Object)viewPager, (String)"viewPager");
        new ViewPagerAttacher().setup(this, viewPager);
    }

    @Deprecated(message="Use attachTo(viewPager) instead", replaceWith=@ReplaceWith(expression="attachTo(viewPager)", imports={}))
    public final void setViewPager2(@NotNull ViewPager2 viewPager2) {
        Intrinsics.checkNotNullParameter((Object)viewPager2, (String)"viewPager2");
        new ViewPager2Attacher().setup(this, viewPager2);
    }

    public final void attachTo(@NotNull ViewPager viewPager) {
        Intrinsics.checkNotNullParameter((Object)viewPager, (String)"viewPager");
        new ViewPagerAttacher().setup(this, viewPager);
    }

    public final void attachTo(@NotNull ViewPager2 viewPager2) {
        Intrinsics.checkNotNullParameter((Object)viewPager2, (String)"viewPager2");
        new ViewPager2Attacher().setup(this, viewPager2);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (Build.VERSION.SDK_INT >= 17 && this.getLayoutDirection() == 1) {
            this.setLayoutDirection(0);
            this.setRotation(180.0f);
            this.requestLayout();
        }
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        super.onRestoreInstanceState(state);
        this.post(() -> BaseDotsIndicator.onRestoreInstanceState$lambda-3(this));
    }

    @JvmOverloads
    public BaseDotsIndicator(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public BaseDotsIndicator(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void onAttachedToWindow$lambda-0(BaseDotsIndicator this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.refreshDots();
    }

    private static final void refreshDots$lambda-1(BaseDotsIndicator this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.refreshDotsCount();
        this$0.refreshDotsColors();
        this$0.refreshDotsSize();
        this$0.refreshOnPageChangedListener();
    }

    private static final void onRestoreInstanceState$lambda-3(BaseDotsIndicator this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.refreshDots();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/tbuonomo/viewpagerdotsindicator/BaseDotsIndicator$Companion;", "", "()V", "DEFAULT_POINT_COLOR", "", "viewpagerdotsindicator_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001BS\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\b\b\u0001\u0010\t\u001a\u00020\b\u0012\b\b\u0001\u0010\n\u001a\u00020\b\u0012\b\b\u0001\u0010\u000b\u001a\u00020\b\u0012\b\b\u0001\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001b\u00a8\u0006\u001c"}, d2={"Lcom/tbuonomo/viewpagerdotsindicator/BaseDotsIndicator$Type;", "", "defaultSize", "", "defaultSpacing", "styleableId", "", "dotsColorId", "", "dotsSizeId", "dotsSpacingId", "dotsCornerRadiusId", "dotsClickableId", "(Ljava/lang/String;IFF[IIIIII)V", "getDefaultSize", "()F", "getDefaultSpacing", "getDotsClickableId", "()I", "getDotsColorId", "getDotsCornerRadiusId", "getDotsSizeId", "getDotsSpacingId", "getStyleableId", "()[I", "DEFAULT", "SPRING", "WORM", "viewpagerdotsindicator_debug"})
    public static final class Type
    extends Enum<Type> {
        private final float defaultSize;
        private final float defaultSpacing;
        @NotNull
        private final int[] styleableId;
        private final int dotsColorId;
        private final int dotsSizeId;
        private final int dotsSpacingId;
        private final int dotsCornerRadiusId;
        private final int dotsClickableId;
        public static final /* enum */ Type DEFAULT;
        public static final /* enum */ Type SPRING;
        public static final /* enum */ Type WORM;
        private static final /* synthetic */ Type[] $VALUES;

        private Type(@StyleableRes float defaultSize, @StyleableRes float defaultSpacing, @StyleableRes int[] styleableId, @StyleableRes int dotsColorId, @StyleableRes int dotsSizeId, @StyleableRes int dotsSpacingId, int dotsCornerRadiusId, int dotsClickableId) {
            this.defaultSize = defaultSize;
            this.defaultSpacing = defaultSpacing;
            this.styleableId = styleableId;
            this.dotsColorId = dotsColorId;
            this.dotsSizeId = dotsSizeId;
            this.dotsSpacingId = dotsSpacingId;
            this.dotsCornerRadiusId = dotsCornerRadiusId;
            this.dotsClickableId = dotsClickableId;
        }

        public final float getDefaultSize() {
            return this.defaultSize;
        }

        public final float getDefaultSpacing() {
            return this.defaultSpacing;
        }

        @NotNull
        public final int[] getStyleableId() {
            return this.styleableId;
        }

        public final int getDotsColorId() {
            return this.dotsColorId;
        }

        public final int getDotsSizeId() {
            return this.dotsSizeId;
        }

        public final int getDotsSpacingId() {
            return this.dotsSpacingId;
        }

        public final int getDotsCornerRadiusId() {
            return this.dotsCornerRadiusId;
        }

        public final int getDotsClickableId() {
            return this.dotsClickableId;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            Intrinsics.checkNotNullExpressionValue((Object)R.styleable.SpringDotsIndicator, (String)"SpringDotsIndicator");
            DEFAULT = new Type(16.0f, 8.0f, R.styleable.SpringDotsIndicator, R.styleable.SpringDotsIndicator_dotsColor, R.styleable.SpringDotsIndicator_dotsSize, R.styleable.SpringDotsIndicator_dotsSpacing, R.styleable.SpringDotsIndicator_dotsCornerRadius, R.styleable.SpringDotsIndicator_dotsClickable);
            Intrinsics.checkNotNullExpressionValue((Object)R.styleable.DotsIndicator, (String)"DotsIndicator");
            SPRING = new Type(16.0f, 4.0f, R.styleable.DotsIndicator, R.styleable.DotsIndicator_dotsColor, R.styleable.DotsIndicator_dotsSize, R.styleable.DotsIndicator_dotsSpacing, R.styleable.DotsIndicator_dotsCornerRadius, R.styleable.SpringDotsIndicator_dotsClickable);
            Intrinsics.checkNotNullExpressionValue((Object)R.styleable.WormDotsIndicator, (String)"WormDotsIndicator");
            WORM = new Type(16.0f, 4.0f, R.styleable.WormDotsIndicator, R.styleable.WormDotsIndicator_dotsColor, R.styleable.WormDotsIndicator_dotsSize, R.styleable.WormDotsIndicator_dotsSpacing, R.styleable.WormDotsIndicator_dotsCornerRadius, R.styleable.SpringDotsIndicator_dotsClickable);
            $VALUES = typeArray = new Type[]{Type.DEFAULT, Type.SPRING, Type.WORM};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\b\u0010\u0010\u001a\u00020\rH&J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\tH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0012\u0010\u000b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/tbuonomo/viewpagerdotsindicator/BaseDotsIndicator$Pager;", "", "count", "", "getCount", "()I", "currentItem", "getCurrentItem", "isEmpty", "", "()Z", "isNotEmpty", "addOnPageChangeListener", "", "onPageChangeListenerHelper", "Lcom/tbuonomo/viewpagerdotsindicator/OnPageChangeListenerHelper;", "removeOnPageChangeListener", "setCurrentItem", "item", "smoothScroll", "viewpagerdotsindicator_debug"})
    public static interface Pager {
        public boolean isNotEmpty();

        public int getCurrentItem();

        public boolean isEmpty();

        public int getCount();

        public void setCurrentItem(int var1, boolean var2);

        public void removeOnPageChangeListener();

        public void addOnPageChangeListener(@NotNull OnPageChangeListenerHelper var1);
    }
}

