/*
 * Decompiled with CFR 0.152.
 */
package com.tbuonomo.viewpagerdotsindicator;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;
import com.tbuonomo.viewpagerdotsindicator.BaseDotsIndicator;
import com.tbuonomo.viewpagerdotsindicator.OnPageChangeListenerHelper;
import com.tbuonomo.viewpagerdotsindicator.R;
import java.util.HashMap;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 +2\u00020\u0001:\u0001+B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\u000e\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u0007J\u000e\u0010'\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u0007J\u0018\u0010(\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010)\u001a\u00020\u0010H\u0002J\b\u0010*\u001a\u00020\u001bH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006,"}, d2={"Lcom/tbuonomo/viewpagerdotsindicator/SpringDotsIndicator;", "Lcom/tbuonomo/viewpagerdotsindicator/BaseDotsIndicator;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "dampingRatio", "", "dotIndicatorColor", "dotIndicatorSize", "dotIndicatorSpring", "Landroidx/dynamicanimation/animation/SpringAnimation;", "dotIndicatorView", "Landroid/view/View;", "dotsStrokeColor", "dotsStrokeWidth", "stiffness", "strokeDotsLinearLayout", "Landroid/widget/LinearLayout;", "type", "Lcom/tbuonomo/viewpagerdotsindicator/BaseDotsIndicator$Type;", "getType", "()Lcom/tbuonomo/viewpagerdotsindicator/BaseDotsIndicator$Type;", "addDot", "", "index", "buildDot", "Landroid/view/ViewGroup;", "stroke", "", "buildOnPageChangedListener", "Lcom/tbuonomo/viewpagerdotsindicator/OnPageChangeListenerHelper;", "refreshDotColor", "removeDot", "setDotIndicatorColor", "color", "setStrokeDotsIndicatorColor", "setUpDotBackground", "dotView", "setUpDotIndicator", "Companion", "viewpagerdotsindicator_release"})
public final class SpringDotsIndicator
extends BaseDotsIndicator {
    private View dotIndicatorView;
    private float dotsStrokeWidth;
    private int dotsStrokeColor;
    private int dotIndicatorColor;
    private float stiffness;
    private float dampingRatio;
    private final float dotIndicatorSize;
    private SpringAnimation dotIndicatorSpring;
    private final LinearLayout strokeDotsLinearLayout;
    private static final float DEFAULT_DAMPING_RATIO = 0.5f;
    private static final int DEFAULT_STIFFNESS = 300;
    @NotNull
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    private final void setUpDotIndicator() {
        BaseDotsIndicator.Pager pager = this.getPager();
        if (pager != null) {
            if (pager.isEmpty()) {
                return;
            }
        }
        if (this.dotIndicatorView != null && this.indexOfChild(this.dotIndicatorView) != -1) {
            this.removeView(this.dotIndicatorView);
        }
        this.dotIndicatorView = (View)this.buildDot(false);
        this.addView(this.dotIndicatorView);
        this.dotIndicatorSpring = new SpringAnimation((Object)this.dotIndicatorView, (FloatPropertyCompat)SpringAnimation.TRANSLATION_X);
        SpringForce springForce = new SpringForce(0.0f);
        springForce.setDampingRatio(this.dampingRatio);
        springForce.setStiffness(this.stiffness);
        SpringAnimation springAnimation = this.dotIndicatorSpring;
        Intrinsics.checkNotNull((Object)springAnimation);
        springAnimation.setSpring(springForce);
    }

    @Override
    public void addDot(int index) {
        ViewGroup dot = this.buildDot(true);
        dot.setOnClickListener(new View.OnClickListener(this, index){
            final /* synthetic */ SpringDotsIndicator this$0;
            final /* synthetic */ int $index;

            public final void onClick(View it) {
                if (this.this$0.getDotsClickable()) {
                    BaseDotsIndicator.Pager pager = this.this$0.getPager();
                    if (this.$index < (pager != null ? pager.getCount() : 0)) {
                        BaseDotsIndicator.Pager pager2 = this.this$0.getPager();
                        Intrinsics.checkNotNull((Object)pager2);
                        pager2.setCurrentItem(this.$index, true);
                    }
                }
            }
            {
                this.this$0 = springDotsIndicator;
                this.$index = n;
            }
        });
        View view = dot.findViewById(R.id.spring_dot);
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.widget.ImageView");
        }
        this.dots.add((ImageView)view);
        this.strokeDotsLinearLayout.addView((View)dot);
    }

    private final ViewGroup buildDot(boolean stroke) {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.spring_dot_layout, (ViewGroup)this, false);
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup dot = (ViewGroup)view;
        if (Build.VERSION.SDK_INT >= 17) {
            dot.setLayoutDirection(0);
        }
        ImageView dotView = (ImageView)dot.findViewById(R.id.spring_dot);
        dotView.setBackgroundResource(stroke ? R.drawable.spring_dot_stroke_background : R.drawable.spring_dot_background);
        ImageView imageView = dotView;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"dotView");
        ViewGroup.LayoutParams layoutParams = imageView.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
        }
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)layoutParams;
        params.width = params.height = (int)(stroke ? this.getDotsSize() : this.dotIndicatorSize);
        params.addRule(15, -1);
        params.setMargins((int)this.getDotsSpacing(), 0, (int)this.getDotsSpacing(), 0);
        this.setUpDotBackground(stroke, (View)dotView);
        return dot;
    }

    private final void setUpDotBackground(boolean stroke, View dotView) {
        View view = dotView.findViewById(R.id.spring_dot);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"dotView.findViewById<View>(R.id.spring_dot)");
        Drawable drawable2 = view.getBackground();
        if (drawable2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
        }
        GradientDrawable dotBackground = (GradientDrawable)drawable2;
        if (stroke) {
            dotBackground.setStroke((int)this.dotsStrokeWidth, this.dotsStrokeColor);
        } else {
            dotBackground.setColor(this.dotIndicatorColor);
        }
        dotBackground.setCornerRadius(this.getDotsCornerRadius());
    }

    @Override
    public void removeDot(int index) {
        this.strokeDotsLinearLayout.removeViewAt(this.strokeDotsLinearLayout.getChildCount() - 1);
        this.dots.remove(this.dots.size() - 1);
    }

    @Override
    public void refreshDotColor(int index) {
        Object e = this.dots.get(index);
        Intrinsics.checkNotNullExpressionValue(e, (String)"dots[index]");
        this.setUpDotBackground(true, (View)e);
    }

    @Override
    @NotNull
    public OnPageChangeListenerHelper buildOnPageChangedListener() {
        return new OnPageChangeListenerHelper(this){
            final /* synthetic */ SpringDotsIndicator this$0;

            public int getPageCount$viewpagerdotsindicator_release() {
                return this.this$0.dots.size();
            }

            public void onPageScrolled$viewpagerdotsindicator_release(int selectedPosition, int nextPosition, float positionOffset) {
                block1: {
                    float distance = this.this$0.getDotsSize() + this.this$0.getDotsSpacing() * (float)2;
                    E e = this.this$0.dots.get(selectedPosition);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"dots[selectedPosition]");
                    ViewParent viewParent = ((ImageView)e).getParent();
                    if (viewParent == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
                    }
                    int x = ((ViewGroup)viewParent).getLeft();
                    float globalPositionOffsetPixels = (float)x + distance * positionOffset;
                    SpringAnimation springAnimation = SpringDotsIndicator.access$getDotIndicatorSpring$p(this.this$0);
                    if (springAnimation == null) break block1;
                    springAnimation.animateToFinalPosition(globalPositionOffsetPixels);
                }
            }

            public void resetPosition$viewpagerdotsindicator_release(int position) {
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    @Override
    @NotNull
    public BaseDotsIndicator.Type getType() {
        return BaseDotsIndicator.Type.SPRING;
    }

    public final void setDotIndicatorColor(int color) {
        if (this.dotIndicatorView != null) {
            this.dotIndicatorColor = color;
            View view = this.dotIndicatorView;
            Intrinsics.checkNotNull((Object)view);
            this.setUpDotBackground(false, view);
        }
    }

    public final void setStrokeDotsIndicatorColor(int color) {
        this.dotsStrokeColor = color;
        Iterator iterator = this.dots.iterator();
        while (iterator.hasNext()) {
            ImageView v;
            ImageView imageView = v = (ImageView)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"v");
            this.setUpDotBackground(true, (View)imageView);
        }
    }

    @JvmOverloads
    public SpringDotsIndicator(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.strokeDotsLinearLayout = new LinearLayout(context);
        float horizontalPadding = this.dpToPxF(24.0f);
        this.setClipToPadding(false);
        this.setPadding((int)horizontalPadding, 0, (int)horizontalPadding, 0);
        this.strokeDotsLinearLayout.setOrientation(0);
        this.addView((View)this.strokeDotsLinearLayout, -2, -2);
        this.dotsStrokeWidth = this.dpToPxF(2.0f);
        this.dotsStrokeColor = this.dotIndicatorColor = this.getThemePrimaryColor(context);
        this.stiffness = 300;
        this.dampingRatio = 0.5f;
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.SpringDotsIndicator);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"getContext().obtainStyle\u2026able.SpringDotsIndicator)");
            TypedArray a = typedArray;
            this.dotIndicatorColor = a.getColor(R.styleable.SpringDotsIndicator_dotsColor, this.dotIndicatorColor);
            this.dotsStrokeColor = a.getColor(R.styleable.SpringDotsIndicator_dotsStrokeColor, this.dotIndicatorColor);
            this.stiffness = a.getFloat(R.styleable.SpringDotsIndicator_stiffness, this.stiffness);
            this.dampingRatio = a.getFloat(R.styleable.SpringDotsIndicator_dampingRatio, this.dampingRatio);
            this.dotsStrokeWidth = a.getDimension(R.styleable.SpringDotsIndicator_dotsStrokeWidth, this.dotsStrokeWidth);
            a.recycle();
        }
        this.dotIndicatorSize = this.getDotsSize();
        if (this.isInEditMode()) {
            this.addDots(5);
            this.addView((View)this.buildDot(false));
        }
        this.setUpDotIndicator();
    }

    public /* synthetic */ SpringDotsIndicator(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public SpringDotsIndicator(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SpringDotsIndicator(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ SpringAnimation access$getDotIndicatorSpring$p(SpringDotsIndicator $this) {
        return $this.dotIndicatorSpring;
    }

    public static final /* synthetic */ void access$setDotIndicatorSpring$p(SpringDotsIndicator $this, SpringAnimation springAnimation) {
        $this.dotIndicatorSpring = springAnimation;
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/tbuonomo/viewpagerdotsindicator/SpringDotsIndicator$Companion;", "", "()V", "DEFAULT_DAMPING_RATIO", "", "DEFAULT_STIFFNESS", "", "viewpagerdotsindicator_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

