/*
 * Decompiled with CFR 0.152.
 */
package com.tbuonomo.viewpagerdotsindicator;

import android.animation.ArgbEvaluator;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.tbuonomo.viewpagerdotsindicator.DotsGradientDrawable;
import com.tbuonomo.viewpagerdotsindicator.OnPageChangeListenerHelper;
import com.tbuonomo.viewpagerdotsindicator.R;
import java.util.ArrayList;
import java.util.List;

public class DotsIndicator
extends LinearLayout {
    private static final int DEFAULT_POINT_COLOR = -16711681;
    public static final float DEFAULT_WIDTH_FACTOR = 2.5f;
    private List<ImageView> dots;
    private ViewPager viewPager;
    private float dotsSize;
    private float dotsCornerRadius;
    private float dotsSpacing;
    private float dotsWidthFactor;
    private int dotsColor;
    private int selectedDotColor;
    private boolean progressMode;
    private boolean dotsClickable;
    private ArgbEvaluator argbEvaluator = new ArgbEvaluator();
    private OnPageChangeListenerHelper onPageChangeListenerHelper;

    public DotsIndicator(Context context) {
        this(context, null);
    }

    public DotsIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DotsIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.dots = new ArrayList<ImageView>();
        this.setOrientation(0);
        this.dotsSize = this.dpToPx(16);
        this.dotsSpacing = this.dpToPx(4);
        this.dotsCornerRadius = this.dotsSize / 2.0f;
        this.dotsWidthFactor = 2.5f;
        this.dotsColor = -16711681;
        this.dotsClickable = true;
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.DotsIndicator);
            this.dotsColor = a.getColor(R.styleable.DotsIndicator_dotsColor, -16711681);
            this.selectedDotColor = a.getColor(R.styleable.DotsIndicator_selectedDotColor, -16711681);
            this.dotsWidthFactor = a.getFloat(R.styleable.DotsIndicator_dotsWidthFactor, 2.5f);
            if (this.dotsWidthFactor < 1.0f) {
                this.dotsWidthFactor = 2.5f;
            }
            this.dotsSize = a.getDimension(R.styleable.DotsIndicator_dotsSize, this.dotsSize);
            this.dotsCornerRadius = (int)a.getDimension(R.styleable.DotsIndicator_dotsCornerRadius, this.dotsSize / 2.0f);
            this.dotsSpacing = a.getDimension(R.styleable.DotsIndicator_dotsSpacing, this.dotsSpacing);
            this.progressMode = a.getBoolean(R.styleable.DotsIndicator_progressMode, false);
            a.recycle();
        }
        if (this.isInEditMode()) {
            this.addDots(5);
        }
        this.refreshDots();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.refreshDots();
    }

    private void refreshDots() {
        if (this.viewPager != null && this.viewPager.getAdapter() != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    DotsIndicator.this.refreshDotsCount();
                    DotsIndicator.this.refreshDotsColors();
                    DotsIndicator.this.refreshDotsSize();
                    DotsIndicator.this.refreshOnPageChangedListener();
                }
            });
        } else {
            Log.e((String)DotsIndicator.class.getSimpleName(), (String)"You have to set an adapter to the view pager before !");
        }
    }

    private void refreshDotsCount() {
        if (this.dots.size() < this.viewPager.getAdapter().getCount()) {
            this.addDots(this.viewPager.getAdapter().getCount() - this.dots.size());
        } else if (this.dots.size() > this.viewPager.getAdapter().getCount()) {
            this.removeDots(this.dots.size() - this.viewPager.getAdapter().getCount());
        }
    }

    private void addDots(int count) {
        int i = 0;
        while (i < count) {
            View dot = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dot_layout, (ViewGroup)this, false);
            ImageView imageView = (ImageView)dot.findViewById(R.id.dot);
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)imageView.getLayoutParams();
            params.width = params.height = (int)this.dotsSize;
            params.setMargins((int)this.dotsSpacing, 0, (int)this.dotsSpacing, 0);
            DotsGradientDrawable background = new DotsGradientDrawable();
            background.setCornerRadius(this.dotsCornerRadius);
            if (this.isInEditMode()) {
                background.setColor(0 == i ? this.selectedDotColor : this.dotsColor);
            } else {
                background.setColor(this.viewPager.getCurrentItem() == i ? this.selectedDotColor : this.dotsColor);
            }
            imageView.setBackground((Drawable)background);
            final int finalI = i++;
            dot.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (DotsIndicator.this.dotsClickable && DotsIndicator.this.viewPager != null && DotsIndicator.this.viewPager.getAdapter() != null && finalI < DotsIndicator.this.viewPager.getAdapter().getCount()) {
                        DotsIndicator.this.viewPager.setCurrentItem(finalI, true);
                    }
                }
            });
            this.dots.add(imageView);
            this.addView(dot);
        }
    }

    private void removeDots(int count) {
        for (int i = 0; i < count; ++i) {
            this.removeViewAt(this.getChildCount() - 1);
            this.dots.remove(this.dots.size() - 1);
        }
    }

    private void refreshOnPageChangedListener() {
        if (this.viewPager != null && this.viewPager.getAdapter() != null && this.viewPager.getAdapter().getCount() > 0) {
            this.viewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this.onPageChangeListenerHelper);
            this.onPageChangeListenerHelper = this.buildOnPageChangedListener();
            this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.onPageChangeListenerHelper);
            this.onPageChangeListenerHelper.onPageScrolled(this.viewPager.getCurrentItem(), -1, 0.0f);
        }
    }

    private OnPageChangeListenerHelper buildOnPageChangedListener() {
        return new OnPageChangeListenerHelper(){

            @Override
            void onPageScrolled(int selectedPosition, int nextPosition, float positionOffset) {
                if (selectedPosition == -1) {
                    return;
                }
                ImageView selectedDot = (ImageView)DotsIndicator.this.dots.get(selectedPosition);
                int selectedDotWidth = (int)(DotsIndicator.this.dotsSize + DotsIndicator.this.dotsSize * (DotsIndicator.this.dotsWidthFactor - 1.0f) * (1.0f - positionOffset));
                DotsIndicator.this.setDotWidth(selectedDot, selectedDotWidth);
                if (nextPosition == -1) {
                    return;
                }
                ImageView nextDot = (ImageView)DotsIndicator.this.dots.get(nextPosition);
                if (nextDot != null) {
                    int nextDotWidth = (int)(DotsIndicator.this.dotsSize + DotsIndicator.this.dotsSize * (DotsIndicator.this.dotsWidthFactor - 1.0f) * positionOffset);
                    DotsIndicator.this.setDotWidth(nextDot, nextDotWidth);
                    DotsGradientDrawable selectedDotBackground = (DotsGradientDrawable)selectedDot.getBackground();
                    DotsGradientDrawable nextDotBackground = (DotsGradientDrawable)nextDot.getBackground();
                    if (DotsIndicator.this.selectedDotColor != DotsIndicator.this.dotsColor) {
                        int selectedColor = (Integer)DotsIndicator.this.argbEvaluator.evaluate(positionOffset, (Object)DotsIndicator.this.selectedDotColor, (Object)DotsIndicator.this.dotsColor);
                        int nextColor = (Integer)DotsIndicator.this.argbEvaluator.evaluate(positionOffset, (Object)DotsIndicator.this.dotsColor, (Object)DotsIndicator.this.selectedDotColor);
                        nextDotBackground.setColor(nextColor);
                        if (DotsIndicator.this.progressMode && selectedPosition <= DotsIndicator.this.viewPager.getCurrentItem()) {
                            selectedDotBackground.setColor(DotsIndicator.this.selectedDotColor);
                        } else {
                            selectedDotBackground.setColor(selectedColor);
                        }
                    }
                }
                DotsIndicator.this.invalidate();
            }

            @Override
            void resetPosition(int position) {
                DotsIndicator.this.setDotWidth((ImageView)DotsIndicator.this.dots.get(position), (int)DotsIndicator.this.dotsSize);
            }

            @Override
            int getPageCount() {
                return DotsIndicator.this.dots.size();
            }
        };
    }

    private void setDotWidth(ImageView dot, int dotWidth) {
        ViewGroup.LayoutParams dotParams = dot.getLayoutParams();
        dotParams.width = dotWidth;
        dot.setLayoutParams(dotParams);
    }

    private void refreshDotsColors() {
        if (this.dots == null) {
            return;
        }
        for (int i = 0; i < this.dots.size(); ++i) {
            ImageView elevationItem = this.dots.get(i);
            DotsGradientDrawable background = (DotsGradientDrawable)elevationItem.getBackground();
            if (i == this.viewPager.getCurrentItem() || this.progressMode && i < this.viewPager.getCurrentItem()) {
                background.setColor(this.selectedDotColor);
            } else {
                background.setColor(this.dotsColor);
            }
            elevationItem.setBackground((Drawable)background);
            elevationItem.invalidate();
        }
    }

    private void refreshDotsSize() {
        if (this.dots == null) {
            return;
        }
        for (int i = 0; i < this.viewPager.getCurrentItem(); ++i) {
            this.setDotWidth(this.dots.get(i), (int)this.dotsSize);
        }
    }

    private void setUpViewPager() {
        if (this.viewPager.getAdapter() != null) {
            this.viewPager.getAdapter().registerDataSetObserver(new DataSetObserver(){

                public void onChanged() {
                    super.onChanged();
                    DotsIndicator.this.refreshDots();
                }
            });
        }
    }

    private int dpToPx(int dp) {
        return (int)(this.getContext().getResources().getDisplayMetrics().density * (float)dp);
    }

    public void setPointsColor(int color) {
        this.dotsColor = color;
        this.refreshDotsColors();
    }

    public void setSelectedPointColor(int color) {
        this.selectedDotColor = color;
        this.refreshDotsColors();
    }

    public void setDotsClickable(boolean dotsClickable) {
        this.dotsClickable = dotsClickable;
    }

    public void setViewPager(ViewPager viewPager) {
        this.viewPager = viewPager;
        this.setUpViewPager();
        this.refreshDots();
    }
}

