/*
 * Decompiled with CFR 0.152.
 */
package com.taxonic.carml.model.impl;

import com.taxonic.carml.model.LogicalSource;
import com.taxonic.carml.model.PredicateObjectMap;
import com.taxonic.carml.model.SubjectMap;
import com.taxonic.carml.model.TriplesMap;
import com.taxonic.carml.model.impl.CarmlLogicalSource;
import com.taxonic.carml.model.impl.CarmlPredicateObjectMap;
import com.taxonic.carml.model.impl.CarmlResource;
import com.taxonic.carml.model.impl.CarmlSubjectMap;
import com.taxonic.carml.rdf_mapper.annotations.RdfProperty;
import com.taxonic.carml.rdf_mapper.annotations.RdfType;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.MultilineRecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class CarmlTriplesMap
extends CarmlResource
implements TriplesMap {
    private LogicalSource logicalSource;
    private SubjectMap subjectMap;
    private Set<PredicateObjectMap> predicateObjectMaps;

    public CarmlTriplesMap() {
    }

    public CarmlTriplesMap(LogicalSource logicalSource, SubjectMap subjectMap, Set<PredicateObjectMap> predicateObjectMaps) {
        this.logicalSource = logicalSource;
        this.subjectMap = subjectMap;
        this.predicateObjectMaps = predicateObjectMaps;
    }

    @Override
    @RdfProperty(value="http://semweb.mmlab.be/ns/rml#logicalSource")
    @RdfType(value=CarmlLogicalSource.class)
    public LogicalSource getLogicalSource() {
        return this.logicalSource;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#subjectMap")
    @RdfType(value=CarmlSubjectMap.class)
    public SubjectMap getSubjectMap() {
        return this.subjectMap;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#predicateObjectMap")
    @RdfType(value=CarmlPredicateObjectMap.class)
    public Set<PredicateObjectMap> getPredicateObjectMaps() {
        return this.predicateObjectMaps;
    }

    public void setLogicalSource(LogicalSource logicalSource) {
        this.logicalSource = logicalSource;
    }

    public void setSubjectMap(SubjectMap subjectMap) {
        this.subjectMap = subjectMap;
    }

    public void setPredicateObjectMaps(Set<PredicateObjectMap> predicateObjectMaps) {
        this.predicateObjectMaps = predicateObjectMaps;
    }

    public String toString() {
        MultilineRecursiveToStringStyle style = new MultilineRecursiveToStringStyle();
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.format("%s %s:%n ", this.getClass().getSimpleName(), this.getResourceName()));
        return new ReflectionToStringBuilder((Object)this, (ToStringStyle)style, buffer).toString();
    }

    public int hashCode() {
        return Objects.hash(this.logicalSource, this.subjectMap, this.predicateObjectMaps);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CarmlTriplesMap other = (CarmlTriplesMap)obj;
        return Objects.equals(this.logicalSource, other.logicalSource) && Objects.equals(this.subjectMap, other.subjectMap) && Objects.equals(this.predicateObjectMaps, other.predicateObjectMaps);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private LogicalSource logicalSource;
        private SubjectMap subjectMap;
        private Set<PredicateObjectMap> predicateObjectMaps = new LinkedHashSet<PredicateObjectMap>();

        public Builder logicalSource(LogicalSource logicalSource) {
            this.logicalSource = logicalSource;
            return this;
        }

        public Builder subjectMap(SubjectMap subjectMap) {
            this.subjectMap = subjectMap;
            return this;
        }

        public Builder predicateObjectMap(PredicateObjectMap predicateObjectMap) {
            this.predicateObjectMaps.add(predicateObjectMap);
            return this;
        }

        public CarmlTriplesMap build() {
            return new CarmlTriplesMap(this.logicalSource, this.subjectMap, this.predicateObjectMaps);
        }
    }
}

