/*
 * Decompiled with CFR 0.152.
 */
package com.taxonic.carml.model.impl;

import com.taxonic.carml.model.TermMap;
import com.taxonic.carml.model.TermType;
import com.taxonic.carml.model.TriplesMap;
import com.taxonic.carml.model.impl.CarmlResource;
import com.taxonic.carml.model.impl.CarmlTriplesMap;
import com.taxonic.carml.rdf_mapper.annotations.RdfProperty;
import com.taxonic.carml.rdf_mapper.annotations.RdfType;
import java.util.Objects;
import org.eclipse.rdf4j.model.Value;

public abstract class CarmlTermMap
extends CarmlResource
implements TermMap {
    String reference;
    String inverseExpression;
    String template;
    TermType termType;
    Value constant;
    TriplesMap functionValue;

    public CarmlTermMap() {
    }

    public CarmlTermMap(String reference, String inverseExpression, String template, TermType termType, Value constant, TriplesMap functionValue) {
        this.reference = reference;
        this.inverseExpression = inverseExpression;
        this.template = template;
        this.termType = termType;
        this.constant = constant;
        this.functionValue = functionValue;
    }

    @Override
    @RdfProperty(value="http://semweb.mmlab.be/ns/rml#reference")
    public String getReference() {
        return this.reference;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#inverseExpression")
    public String getInverseExpression() {
        return this.inverseExpression;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#template")
    public String getTemplate() {
        return this.template;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#termType")
    public TermType getTermType() {
        return this.termType;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#constant")
    public Value getConstant() {
        return this.constant;
    }

    @Override
    @RdfProperty(value="http://semweb.mmlab.be/ns/fnml#functionValue")
    @RdfType(value=CarmlTriplesMap.class)
    public TriplesMap getFunctionValue() {
        return this.functionValue;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public void setInverseExpression(String inverseExpression) {
        this.inverseExpression = inverseExpression;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setTermType(TermType termType) {
        this.termType = termType;
    }

    public void setConstant(Value constant) {
        this.constant = constant;
    }

    public void setFunctionValue(TriplesMap functionValue) {
        this.functionValue = functionValue;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reference, this.inverseExpression, this.template, this.termType, this.constant, this.functionValue});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CarmlTermMap other = (CarmlTermMap)obj;
        return Objects.equals(this.reference, other.reference) && Objects.equals(this.inverseExpression, other.inverseExpression) && Objects.equals(this.template, other.template) && Objects.equals((Object)this.termType, (Object)other.termType) && Objects.equals(this.constant, other.constant) && Objects.equals(this.functionValue, other.functionValue);
    }

    public static class Builder {
        String reference;
        String inverseExpression;
        String template;
        TermType termType;
        Value constant;
        TriplesMap functionValue;

        Builder reference(String reference) {
            this.reference = reference;
            return this;
        }

        Builder inverseExpression(String inverseExpression) {
            this.inverseExpression = inverseExpression;
            return this;
        }

        Builder template(String template) {
            this.template = template;
            return this;
        }

        Builder termType(TermType termType) {
            this.termType = termType;
            return this;
        }

        Builder constant(Value constant) {
            this.constant = constant;
            return this;
        }

        Builder functionValue(TriplesMap functionValue) {
            this.functionValue = functionValue;
            return this;
        }

        String getReference() {
            return this.reference;
        }

        String getInverseExpression() {
            return this.inverseExpression;
        }

        String getTemplate() {
            return this.template;
        }

        TermType getTermType() {
            return this.termType;
        }

        Value getConstant() {
            return this.constant;
        }

        TriplesMap getFunctionValue() {
            return this.functionValue;
        }
    }
}

