/*
 * Decompiled with CFR 0.152.
 */
package com.taxonic.carml.model.impl;

import com.taxonic.carml.model.GraphMap;
import com.taxonic.carml.model.SubjectMap;
import com.taxonic.carml.model.TermType;
import com.taxonic.carml.model.TriplesMap;
import com.taxonic.carml.model.impl.CarmlGraphMap;
import com.taxonic.carml.model.impl.CarmlTermMap;
import com.taxonic.carml.rdf_mapper.annotations.RdfProperty;
import com.taxonic.carml.rdf_mapper.annotations.RdfType;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.MultilineRecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;

public class CarmlSubjectMap
extends CarmlTermMap
implements SubjectMap {
    private Set<IRI> classes;
    private Set<GraphMap> graphMaps;

    public CarmlSubjectMap() {
    }

    public CarmlSubjectMap(String reference, String inverseExpression, String template, TermType termType, Value constant, TriplesMap functionValue, Set<IRI> classes, Set<GraphMap> graphMaps) {
        super(reference, inverseExpression, template, termType, constant, functionValue);
        this.classes = classes;
        this.graphMaps = graphMaps;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#graphMap")
    @RdfType(value=CarmlGraphMap.class)
    public Set<GraphMap> getGraphMaps() {
        return this.graphMaps;
    }

    public void setGraphMaps(Set<GraphMap> graphMaps) {
        this.graphMaps = graphMaps;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#class")
    public Set<IRI> getClasses() {
        return this.classes;
    }

    public void setClasses(Set<IRI> classes) {
        this.classes = classes;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, (ToStringStyle)new MultilineRecursiveToStringStyle()).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classes, this.graphMaps, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CarmlSubjectMap other = (CarmlSubjectMap)obj;
        return Objects.equals(this.classes, other.classes) && Objects.equals(this.graphMaps, other.graphMaps);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends CarmlTermMap.Builder {
        private Set<IRI> classes = new LinkedHashSet<IRI>();
        private Set<GraphMap> graphMaps = new LinkedHashSet<GraphMap>();

        @Override
        public Builder reference(String reference) {
            super.reference(reference);
            return this;
        }

        @Override
        public Builder inverseExpression(String inverseExpression) {
            super.inverseExpression(inverseExpression);
            return this;
        }

        @Override
        public Builder template(String template) {
            super.template(template);
            return this;
        }

        @Override
        public Builder termType(TermType termType) {
            super.termType(termType);
            return this;
        }

        @Override
        public Builder constant(Value constant) {
            super.constant(constant);
            return this;
        }

        @Override
        public Builder functionValue(TriplesMap functionValue) {
            super.functionValue(functionValue);
            return this;
        }

        public Builder clazz(IRI clazz) {
            this.classes.add(clazz);
            return this;
        }

        public Builder classes(Set<IRI> classes) {
            this.classes = classes;
            return this;
        }

        public Builder graphMap(CarmlGraphMap carmlGraphMap) {
            this.graphMaps.add(carmlGraphMap);
            return this;
        }

        public Builder graphMaps(Set<GraphMap> graphMaps) {
            this.graphMaps = graphMaps;
            return this;
        }

        public CarmlSubjectMap build() {
            return new CarmlSubjectMap(this.getReference(), this.getInverseExpression(), this.getTemplate(), this.getTermType(), this.getConstant(), this.getFunctionValue(), this.classes, this.graphMaps);
        }
    }
}

