/*
 * Decompiled with CFR 0.152.
 */
package com.taxonic.carml.model.impl;

import com.taxonic.carml.model.Join;
import com.taxonic.carml.model.RefObjectMap;
import com.taxonic.carml.model.TriplesMap;
import com.taxonic.carml.model.impl.CarmlJoin;
import com.taxonic.carml.model.impl.CarmlResource;
import com.taxonic.carml.model.impl.CarmlTriplesMap;
import com.taxonic.carml.rdf_mapper.annotations.RdfProperty;
import com.taxonic.carml.rdf_mapper.annotations.RdfType;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.MultilineRecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class CarmlRefObjectMap
extends CarmlResource
implements RefObjectMap {
    TriplesMap parentTriplesMap;
    Set<Join> joinConditions;

    public CarmlRefObjectMap() {
    }

    public CarmlRefObjectMap(TriplesMap parentTriplesMap, Set<Join> joinConditions) {
        this.parentTriplesMap = parentTriplesMap;
        this.joinConditions = joinConditions;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#parentTriplesMap")
    @RdfType(value=CarmlTriplesMap.class)
    public TriplesMap getParentTriplesMap() {
        return this.parentTriplesMap;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#joinCondition")
    @RdfType(value=CarmlJoin.class)
    public Set<Join> getJoinConditions() {
        return this.joinConditions;
    }

    public void setParentTriplesMap(TriplesMap parentTriplesMap) {
        this.parentTriplesMap = parentTriplesMap;
    }

    public void setJoinConditions(Set<Join> joinConditions) {
        this.joinConditions = joinConditions;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, (ToStringStyle)new MultilineRecursiveToStringStyle()).toString();
    }

    public int hashCode() {
        return Objects.hash(this.parentTriplesMap, this.joinConditions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CarmlRefObjectMap other = (CarmlRefObjectMap)obj;
        return Objects.equals(this.parentTriplesMap, other.parentTriplesMap) && Objects.equals(this.joinConditions, other.joinConditions);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        TriplesMap parentTriplesMap;
        Set<Join> joinConditions = new LinkedHashSet<Join>();

        Builder() {
        }

        public Builder parentTriplesMap(TriplesMap parentTriplesMap) {
            this.parentTriplesMap = parentTriplesMap;
            return this;
        }

        public Builder joinConditions(Set<Join> joinConditions) {
            this.joinConditions = joinConditions;
            return this;
        }

        public Builder condition(Join condition) {
            this.joinConditions.add(condition);
            return this;
        }

        public CarmlRefObjectMap build() {
            return new CarmlRefObjectMap(this.parentTriplesMap, this.joinConditions);
        }
    }
}

