/*
 * Decompiled with CFR 0.152.
 */
package com.taxonic.carml.model.impl;

import com.taxonic.carml.model.BaseObjectMap;
import com.taxonic.carml.model.GraphMap;
import com.taxonic.carml.model.PredicateMap;
import com.taxonic.carml.model.PredicateObjectMap;
import com.taxonic.carml.model.impl.CarmlGraphMap;
import com.taxonic.carml.model.impl.CarmlPredicateMap;
import com.taxonic.carml.model.impl.CarmlResource;
import com.taxonic.carml.model.impl.ObjectMapTypeDecider;
import com.taxonic.carml.rdf_mapper.annotations.RdfProperty;
import com.taxonic.carml.rdf_mapper.annotations.RdfType;
import com.taxonic.carml.rdf_mapper.annotations.RdfTypeDecider;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.MultilineRecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class CarmlPredicateObjectMap
extends CarmlResource
implements PredicateObjectMap {
    private Set<PredicateMap> predicateMaps;
    private Set<BaseObjectMap> objectMaps;
    private Set<GraphMap> graphMaps;

    public CarmlPredicateObjectMap() {
    }

    public CarmlPredicateObjectMap(Set<PredicateMap> predicateMaps, Set<BaseObjectMap> objectMaps, Set<GraphMap> graphMaps) {
        this.predicateMaps = predicateMaps;
        this.objectMaps = objectMaps;
        this.graphMaps = graphMaps;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#predicateMap")
    @RdfType(value=CarmlPredicateMap.class)
    public Set<PredicateMap> getPredicateMaps() {
        return this.predicateMaps;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#objectMap")
    @RdfTypeDecider(value=ObjectMapTypeDecider.class)
    public Set<BaseObjectMap> getObjectMaps() {
        return this.objectMaps;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#graphMap")
    @RdfType(value=CarmlGraphMap.class)
    public Set<GraphMap> getGraphMaps() {
        return this.graphMaps;
    }

    public void setPredicateMaps(Set<PredicateMap> predicateMaps) {
        this.predicateMaps = predicateMaps;
    }

    public void setObjectMaps(Set<BaseObjectMap> objectMaps) {
        this.objectMaps = objectMaps;
    }

    public void setGraphMaps(Set<GraphMap> graphMaps) {
        this.graphMaps = graphMaps;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, (ToStringStyle)new MultilineRecursiveToStringStyle()).toString();
    }

    public int hashCode() {
        return Objects.hash(this.predicateMaps, this.objectMaps, this.graphMaps);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CarmlPredicateObjectMap other = (CarmlPredicateObjectMap)obj;
        return Objects.equals(this.predicateMaps, other.predicateMaps) && Objects.equals(this.objectMaps, other.objectMaps) && Objects.equals(this.graphMaps, other.graphMaps);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Set<PredicateMap> predicateMaps = new LinkedHashSet<PredicateMap>();
        private Set<BaseObjectMap> objectMaps = new LinkedHashSet<BaseObjectMap>();
        private Set<GraphMap> graphMaps = new LinkedHashSet<GraphMap>();

        public Builder predicateMap(PredicateMap predicateMap) {
            this.predicateMaps.add(predicateMap);
            return this;
        }

        public Builder objectMap(BaseObjectMap objectMap) {
            this.objectMaps.add(objectMap);
            return this;
        }

        public Builder graphMap(CarmlGraphMap carmlGraphMap) {
            this.graphMaps.add(carmlGraphMap);
            return this;
        }

        public Builder graphMaps(Set<GraphMap> graphMaps) {
            this.graphMaps = graphMaps;
            return this;
        }

        public CarmlPredicateObjectMap build() {
            return new CarmlPredicateObjectMap(this.predicateMaps, this.objectMaps, this.graphMaps);
        }
    }
}

