/*
 * Decompiled with CFR 0.152.
 */
package com.taxonic.carml.model.impl;

import com.taxonic.carml.model.MultiObjectMap;
import com.taxonic.carml.model.TermType;
import com.taxonic.carml.model.TriplesMap;
import com.taxonic.carml.model.impl.CarmlMultiTermMap;
import com.taxonic.carml.model.impl.CarmlTermMap;
import com.taxonic.carml.rdf_mapper.annotations.RdfProperty;
import java.util.Objects;
import org.apache.commons.lang3.builder.MultilineRecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;

public class CarmlMultiObjectMap
extends CarmlMultiTermMap
implements MultiObjectMap {
    private IRI datatype;
    private String language;

    public CarmlMultiObjectMap() {
    }

    CarmlMultiObjectMap(String reference, String inverseExpression, String template, TermType termType, Value constant, TriplesMap functionValue, IRI datatype, String language) {
        super(reference, inverseExpression, template, termType, constant, functionValue);
        this.datatype = datatype;
        this.language = language;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#datatype")
    public IRI getDatatype() {
        return this.datatype;
    }

    @Override
    @RdfProperty(value="http://www.w3.org/ns/r2rml#language")
    public String getLanguage() {
        return this.language;
    }

    public void setDatatype(IRI datatype) {
        this.datatype = datatype;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder((Object)this, (ToStringStyle)new MultilineRecursiveToStringStyle()).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.datatype, this.language, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CarmlMultiObjectMap other = (CarmlMultiObjectMap)obj;
        return Objects.equals(this.datatype, other.datatype) && Objects.equals(this.language, other.language);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends CarmlTermMap.Builder {
        private IRI datatype;
        private String language;

        public Builder datatype(IRI datatype) {
            this.datatype = datatype;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public CarmlMultiObjectMap build() {
            return new CarmlMultiObjectMap(this.getReference(), this.getInverseExpression(), this.getTemplate(), this.getTermType(), this.getConstant(), this.getFunctionValue(), this.datatype, this.language);
        }
    }
}

