/*
 * Decompiled with CFR 0.152.
 */
package com.taxjar.exception;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;

public class TaxjarException
extends Exception {
    private Integer statusCode;

    public TaxjarException(String errorMessage) {
        this(errorMessage, null);
    }

    public TaxjarException(String errorMessage, Throwable err) {
        super(TaxjarException.parseMessage(errorMessage), err);
        this.statusCode = TaxjarException.parseStatusCode(errorMessage);
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    private static String parseMessage(String errorMessage) {
        Gson gson = new Gson();
        try {
            JsonObject json = (JsonObject)gson.fromJson(errorMessage, JsonObject.class);
            return json.get("error").getAsString() + " - " + json.get("detail").getAsString();
        }
        catch (JsonSyntaxException e) {
            return errorMessage;
        }
    }

    private static Integer parseStatusCode(String errorMessage) {
        Gson gson = new Gson();
        try {
            JsonObject json = (JsonObject)gson.fromJson(errorMessage, JsonObject.class);
            return json.get("status").getAsInt();
        }
        catch (JsonSyntaxException e) {
            return 0;
        }
    }
}

