/*
 * Decompiled with CFR 0.152.
 */
package com.taxjar.net;

import com.taxjar.model.categories.CategoryResponse;
import com.taxjar.model.nexus.RegionResponse;
import com.taxjar.model.rates.RateResponse;
import com.taxjar.model.summarized_rates.SummaryRateResponse;
import com.taxjar.model.taxes.TaxResponse;
import com.taxjar.model.transactions.OrderResponse;
import com.taxjar.model.transactions.OrdersResponse;
import com.taxjar.model.transactions.RefundResponse;
import com.taxjar.model.transactions.RefundsResponse;
import com.taxjar.model.validations.ValidationResponse;
import java.util.Map;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public interface Endpoints {
    @GET(value="categories")
    public Call<CategoryResponse> getCategories();

    @GET(value="rates/{zip}")
    public Call<RateResponse> getRate(@Path(value="zip") String var1);

    @GET(value="rates/{zip}")
    public Call<RateResponse> getRate(@Path(value="zip") String var1, @QueryMap Map<String, String> var2);

    @POST(value="taxes")
    public Call<TaxResponse> getTax(@Body Map<String, Object> var1);

    @GET(value="transactions/orders")
    public Call<OrdersResponse> getOrders();

    @GET(value="transactions/orders")
    public Call<OrdersResponse> getOrders(@QueryMap Map<String, String> var1);

    @GET(value="transactions/orders/{transactionId}")
    public Call<OrderResponse> getOrder(@Path(value="transactionId") String var1);

    @POST(value="transactions/orders")
    public Call<OrderResponse> createOrder(@Body Map<String, Object> var1);

    @PUT(value="transactions/orders/{transactionId}")
    public Call<OrderResponse> updateOrder(@Path(value="transactionId") String var1, @Body Map<String, Object> var2);

    @DELETE(value="transactions/orders/{transactionId}")
    public Call<OrderResponse> deleteOrder(@Path(value="transactionId") String var1);

    @GET(value="transactions/refunds")
    public Call<RefundsResponse> getRefunds();

    @GET(value="transactions/refunds")
    public Call<RefundsResponse> getRefunds(@QueryMap Map<String, String> var1);

    @GET(value="transactions/refunds/{transactionId}")
    public Call<RefundResponse> getRefund(@Path(value="transactionId") String var1);

    @POST(value="transactions/refunds")
    public Call<RefundResponse> createRefund(@Body Map<String, Object> var1);

    @PUT(value="transactions/refunds/{transactionId}")
    public Call<RefundResponse> updateRefund(@Path(value="transactionId") String var1, @Body Map<String, Object> var2);

    @DELETE(value="transactions/refunds/{transactionId}")
    public Call<RefundResponse> deleteRefund(@Path(value="transactionId") String var1);

    @GET(value="nexus/regions")
    public Call<RegionResponse> getRegions();

    @GET(value="validation")
    public Call<ValidationResponse> getValidation(@QueryMap Map<String, String> var1);

    @GET(value="summary_rates")
    public Call<SummaryRateResponse> getSummaryRates();
}

