/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lipermi.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;
import net.sf.lipermi.handler.CallHandler;
import net.sf.lipermi.handler.ConnectionHandler;
import net.sf.lipermi.handler.IConnectionHandlerListener;
import net.sf.lipermi.handler.filter.DefaultFilter;
import net.sf.lipermi.handler.filter.IProtocolFilter;
import net.sf.lipermi.net.IServerListener;

public class Server {
    private ServerSocket serverSocket;
    private boolean enabled;
    private final List<IServerListener> listeners = new LinkedList<IServerListener>();

    public void addServerListener(IServerListener listener) {
        this.listeners.add(listener);
    }

    public void removeServerListener(IServerListener listener) {
        this.listeners.remove(listener);
    }

    public void close() {
        this.enabled = false;
    }

    public void bind(int port, CallHandler callHandler) throws IOException {
        this.bind(port, callHandler, new DefaultFilter());
    }

    public void bind(int port, final CallHandler callHandler, final IProtocolFilter filter) throws IOException {
        this.serverSocket = new ServerSocket();
        this.serverSocket.setPerformancePreferences(1, 0, 2);
        this.enabled = true;
        this.serverSocket.bind(new InetSocketAddress(port));
        Thread bindThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (Server.this.enabled) {
                    try {
                        Socket acceptSocket;
                        final Socket clientSocket = acceptSocket = Server.this.serverSocket.accept();
                        ConnectionHandler.createConnectionHandler(clientSocket, callHandler, filter, new IConnectionHandlerListener(){

                            @Override
                            public void connectionClosed() {
                                for (IServerListener listener : Server.this.listeners) {
                                    listener.clientDisconnected(clientSocket);
                                }
                            }
                        });
                        for (IServerListener listener : Server.this.listeners) {
                            listener.clientConnected(clientSocket);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, String.format("Bind (%d)", port));
        bindThread.start();
    }
}

