/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lipermi.handler.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.sf.lipermi.call.IRemoteMessage;
import net.sf.lipermi.handler.filter.IProtocolFilter;

public class GZipFilter
implements IProtocolFilter {
    @Override
    public IRemoteMessage readObject(Object obj) {
        IRemoteMessage remoteMessage = null;
        GZIPInputStream gzis = null;
        ObjectInputStream ois = null;
        try {
            int b;
            ByteArrayInputStream bais = new ByteArrayInputStream((byte[])obj);
            gzis = new GZIPInputStream(bais);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = gzis.read()) != -1) {
                baos.write(b);
            }
            gzis.close();
            byte[] extractedObj = baos.toByteArray();
            bais = new ByteArrayInputStream(extractedObj);
            ois = new ObjectInputStream(bais);
            remoteMessage = (IRemoteMessage)ois.readUnshared();
            ois.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't read message", e);
        }
        finally {
            if (gzis != null) {
                try {
                    gzis.close();
                }
                catch (IOException iOException) {}
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
        }
        return remoteMessage;
    }

    @Override
    public Object prepareWrite(IRemoteMessage message) {
        Object objectToWrite = message;
        ObjectOutputStream oos = null;
        DeflaterOutputStream gzos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeUnshared(message);
            byte[] byteObj = baos.toByteArray();
            baos.reset();
            gzos = new GZIPOutputStream(baos);
            gzos.write(byteObj);
            ((GZIPOutputStream)gzos).finish();
            byteObj = baos.toByteArray();
            objectToWrite = byteObj;
        }
        catch (Exception e) {
            throw new RuntimeException("Can't prepare message", e);
        }
        finally {
            if (gzos != null) {
                try {
                    gzos.close();
                }
                catch (IOException iOException) {}
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return objectToWrite;
    }
}

