/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lipermi.handler;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.sf.lipermi.call.IRemoteMessage;
import net.sf.lipermi.call.RemoteCall;
import net.sf.lipermi.call.RemoteInstance;
import net.sf.lipermi.call.RemoteReturn;
import net.sf.lipermi.exception.LipeRMIException;
import net.sf.lipermi.handler.CallHandler;
import net.sf.lipermi.handler.CallLookup;
import net.sf.lipermi.handler.CallProxy;
import net.sf.lipermi.handler.IConnectionHandlerListener;
import net.sf.lipermi.handler.filter.IProtocolFilter;

public class ConnectionHandler
implements Runnable {
    private final CallHandler callHandler;
    private final Socket socket;
    private ObjectOutputStream output;
    private static final AtomicLong callId = new AtomicLong(0L);
    private final IProtocolFilter filter;
    private final List<IConnectionHandlerListener> listeners = new LinkedList<IConnectionHandlerListener>();
    private final Map<RemoteInstance, Object> remoteInstanceProxys = new HashMap<RemoteInstance, Object>();
    private final List<RemoteReturn> remoteReturns = new LinkedList<RemoteReturn>();

    public static ConnectionHandler createConnectionHandler(Socket socket, CallHandler callHandler, IProtocolFilter filter) {
        ConnectionHandler connectionHandler = new ConnectionHandler(socket, callHandler, filter);
        String threadName = String.format("ConnectionHandler (%s:%d)", socket.getInetAddress().getHostAddress(), socket.getPort());
        Thread connectionHandlerThread = new Thread((Runnable)connectionHandler, threadName);
        connectionHandlerThread.setDaemon(true);
        connectionHandlerThread.start();
        return connectionHandler;
    }

    public static ConnectionHandler createConnectionHandler(Socket socket, CallHandler callHandler, IProtocolFilter filter, IConnectionHandlerListener listener) {
        ConnectionHandler connectionHandler = ConnectionHandler.createConnectionHandler(socket, callHandler, filter);
        connectionHandler.addConnectionHandlerListener(listener);
        return connectionHandler;
    }

    public void addConnectionHandlerListener(IConnectionHandlerListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionHandlerListener(IConnectionHandlerListener listener) {
        this.listeners.remove(listener);
    }

    private ConnectionHandler(Socket socket, CallHandler callHandler, IProtocolFilter filter) {
        this.callHandler = callHandler;
        this.socket = socket;
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ObjectInputStream input = new ObjectInputStream(this.socket.getInputStream());
            while (this.socket.isConnected()) {
                Object objFromStream = input.readUnshared();
                IRemoteMessage remoteMessage = this.filter.readObject(objFromStream);
                if (remoteMessage instanceof RemoteCall) {
                    final RemoteCall remoteCall = (RemoteCall)remoteMessage;
                    if (remoteCall.getArgs() != null) {
                        for (int n = 0; n < remoteCall.getArgs().length; ++n) {
                            Object arg = remoteCall.getArgs()[n];
                            if (!(arg instanceof RemoteInstance)) continue;
                            RemoteInstance remoteInstance = (RemoteInstance)arg;
                            remoteCall.getArgs()[n] = this.getProxyFromRemoteInstance(remoteInstance);
                        }
                    }
                    Thread delegator = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            CallLookup.handlingMe(ConnectionHandler.this);
                            try {
                                RemoteReturn remoteReturn = ConnectionHandler.this.callHandler.delegateCall(remoteCall);
                                ConnectionHandler.this.sendMessage(remoteReturn);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            CallLookup.forgetMe();
                        }
                    }, "Delegator");
                    delegator.setDaemon(true);
                    delegator.start();
                    continue;
                }
                if (remoteMessage instanceof RemoteReturn) {
                    RemoteReturn remoteReturn = (RemoteReturn)remoteMessage;
                    List<RemoteReturn> list = this.remoteReturns;
                    synchronized (list) {
                        this.remoteReturns.add(remoteReturn);
                        this.remoteReturns.notifyAll();
                        continue;
                    }
                }
                throw new LipeRMIException("Unknown IRemoteMessage type");
            }
        }
        catch (IOException | ClassNotFoundException | LipeRMIException e) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            List<RemoteReturn> list = this.remoteReturns;
            synchronized (list) {
                this.remoteReturns.notifyAll();
            }
            for (IConnectionHandlerListener listener : this.listeners) {
                listener.connectionClosed();
            }
        }
    }

    private synchronized void sendMessage(IRemoteMessage remoteMessage) throws IOException {
        if (this.output == null) {
            this.output = new ObjectOutputStream(this.socket.getOutputStream());
        }
        Object objToWrite = this.filter.prepareWrite(remoteMessage);
        this.output.reset();
        this.output.writeUnshared(objToWrite);
        this.output.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized Object remoteInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        Long id = callId.getAndIncrement();
        RemoteInstance remoteInstance = this.getRemoteInstanceFromProxy(proxy);
        if (remoteInstance == null) {
            remoteInstance = new RemoteInstance(null, proxy.getClass().getInterfaces()[0].getName());
        }
        if (args != null) {
            for (int n = 0; n < args.length; ++n) {
                RemoteInstance remoteRef = this.callHandler.getRemoteReference(args[n]);
                if (remoteRef == null) continue;
                args[n] = remoteRef;
            }
        }
        String methodId = method.toString().substring(15);
        RemoteCall remoteCall = new RemoteCall(remoteInstance, methodId, args, id);
        this.sendMessage(remoteCall);
        RemoteReturn remoteReturn = null;
        boolean bReturned = false;
        do {
            List<RemoteReturn> list = this.remoteReturns;
            synchronized (list) {
                for (RemoteReturn ret : this.remoteReturns) {
                    if (!ret.getCallId().equals(id)) continue;
                    bReturned = true;
                    remoteReturn = ret;
                    break;
                }
                if (bReturned) {
                    this.remoteReturns.remove(remoteReturn);
                } else {
                    try {
                        this.remoteReturns.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        } while (this.socket.isConnected() && !bReturned);
        if (!this.socket.isConnected() && !bReturned) {
            throw new LipeRMIException("Connection aborted");
        }
        if (remoteReturn.isThrowing() && remoteReturn.getRet() instanceof Throwable) {
            throw ((Throwable)remoteReturn.getRet()).getCause();
        }
        if (remoteReturn.getRet() instanceof RemoteInstance) {
            RemoteInstance remoteInstanceReturn = (RemoteInstance)remoteReturn.getRet();
            Object proxyReturn = this.remoteInstanceProxys.get(remoteInstanceReturn);
            if (proxyReturn == null) {
                proxyReturn = CallProxy.buildProxy(remoteInstanceReturn, this);
                this.remoteInstanceProxys.put(remoteInstanceReturn, proxyReturn);
            }
            return proxyReturn;
        }
        return remoteReturn.getRet();
    }

    private Object getProxyFromRemoteInstance(RemoteInstance remoteInstance) {
        Object proxy = this.remoteInstanceProxys.get(remoteInstance);
        if (proxy == null) {
            try {
                proxy = CallProxy.buildProxy(remoteInstance, this);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            this.remoteInstanceProxys.put(remoteInstance, proxy);
        }
        return proxy;
    }

    private RemoteInstance getRemoteInstanceFromProxy(Object proxy) {
        for (RemoteInstance remoteInstance : this.remoteInstanceProxys.keySet()) {
            if (this.remoteInstanceProxys.get(remoteInstance) != proxy) continue;
            return remoteInstance;
        }
        return null;
    }

    public Socket getSocket() {
        return this.socket;
    }
}

