/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lipermi.handler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.sf.lipermi.call.RemoteCall;
import net.sf.lipermi.call.RemoteInstance;
import net.sf.lipermi.call.RemoteReturn;
import net.sf.lipermi.exception.LipeRMIException;

public class CallHandler {
    private final Map<RemoteInstance, Object> exportedObjects = new HashMap<RemoteInstance, Object>();

    public void registerGlobal(Class<?> cInterface, Object objImplementation) throws LipeRMIException {
        this.exportObject(cInterface, objImplementation, null);
    }

    public void exportObject(Class<?> cInterface, Object exportedObject) throws LipeRMIException {
        UUID objUUID = UUID.randomUUID();
        String instanceId = objUUID.toString();
        this.exportObject(cInterface, exportedObject, instanceId);
    }

    private void exportObject(Class<?> cInterface, Object objImplementation, String instanceId) throws LipeRMIException {
        if (!cInterface.isAssignableFrom(objImplementation.getClass())) {
            throw new LipeRMIException(String.format("Class %s is not assignable from %s", objImplementation.getClass().getName(), cInterface.getName()));
        }
        for (RemoteInstance remoteInstance : this.exportedObjects.keySet()) {
            if (!(remoteInstance.getInstanceId() != null ? remoteInstance.getInstanceId().equals(instanceId) : instanceId == null)) {
                if (remoteInstance.getInstanceId() == null || !remoteInstance.getInstanceId().equals(instanceId)) continue;
            }
            if (!remoteInstance.getClassName().equals(cInterface.getName())) continue;
            throw new LipeRMIException(String.format("Class %s already has a implementation class", cInterface.getName()));
        }
        RemoteInstance remoteInstance = new RemoteInstance(instanceId, cInterface.getName());
        this.exportedObjects.put(remoteInstance, objImplementation);
    }

    public RemoteReturn delegateCall(RemoteCall remoteCall) throws LipeRMIException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException {
        RemoteReturn remoteReturn;
        boolean found;
        String remoteInstanceClassName = remoteCall.getRemoteInstance().getClassName();
        String remoteMethodId = remoteCall.getMethodId().trim();
        int i = remoteMethodId.indexOf(" ");
        int j = remoteMethodId.indexOf("(");
        int k = remoteMethodId.lastIndexOf(".", j);
        remoteMethodId = remoteMethodId.substring(0, i + 1) + remoteInstanceClassName + remoteMethodId.substring(k);
        Object implementator = this.exportedObjects.get(remoteCall.getRemoteInstance());
        if (implementator == null) {
            throw new LipeRMIException(String.format("Class %s doesn't have implementation", remoteCall.getRemoteInstance().getClassName()));
        }
        Method implementationMethod = null;
        Class<?> klass = implementator.getClass();
        block2: do {
            found = false;
            for (Method method : klass.getMethods()) {
                String implementationMethodId = method.toString();
                if (!(implementationMethodId = implementationMethodId.replace(klass.getName(), remoteInstanceClassName)).endsWith(remoteMethodId)) continue;
                implementationMethod = method;
                found = true;
                continue block2;
            }
        } while (!found && !(klass = klass.getSuperclass()).equals(Object.class));
        if (implementationMethod == null) {
            throw new NoSuchMethodException(remoteCall.getMethodId());
        }
        try {
            implementationMethod.setAccessible(true);
            Object methodReturn = implementationMethod.invoke(implementator, remoteCall.getArgs());
            if (this.exportedObjects.containsValue(methodReturn)) {
                methodReturn = this.getRemoteReference(methodReturn);
            }
            remoteReturn = new RemoteReturn(false, methodReturn, remoteCall.getCallId());
        }
        catch (InvocationTargetException e) {
            remoteReturn = new RemoteReturn(true, e, remoteCall.getCallId());
        }
        return remoteReturn;
    }

    RemoteInstance getRemoteReference(Object obj) {
        for (RemoteInstance remoteInstance : this.exportedObjects.keySet()) {
            Object exportedObj = this.exportedObjects.get(remoteInstance);
            if (exportedObj != obj) continue;
            return remoteInstance;
        }
        return null;
    }

    public static Class<?>[] typeFromObjects(Object[] objects) {
        Class[] argClasses = null;
        if (objects != null) {
            argClasses = new Class[objects.length];
            for (int n = 0; n < objects.length; ++n) {
                Object obj = objects[n];
                argClasses[n++] = obj.getClass();
            }
        }
        return argClasses;
    }
}

