/*
 * Decompiled with CFR 0.152.
 */
package net.sf.lipermi.net;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;
import net.sf.lipermi.handler.CallHandler;
import net.sf.lipermi.handler.CallProxy;
import net.sf.lipermi.handler.ConnectionHandler;
import net.sf.lipermi.handler.IConnectionHandlerListener;
import net.sf.lipermi.handler.filter.DefaultFilter;
import net.sf.lipermi.handler.filter.IProtocolFilter;
import net.sf.lipermi.net.IClientListener;

public class Client {
    private Socket socket;
    private ConnectionHandler connectionHandler;
    private final IConnectionHandlerListener connectionHandlerListener = new IConnectionHandlerListener(){

        @Override
        public void connectionClosed() {
            for (IClientListener listener : Client.this.listeners) {
                listener.disconnected();
            }
        }
    };
    private List<IClientListener> listeners = new LinkedList<IClientListener>();

    public void addClientListener(IClientListener listener) {
        this.listeners.add(listener);
    }

    public void removeClientListener(IClientListener listener) {
        this.listeners.remove(listener);
    }

    public Client(String address, int port, CallHandler callHandler) throws IOException {
        this(address, port, callHandler, new DefaultFilter());
    }

    public Client(String address, int port, CallHandler callHandler, IProtocolFilter filter) throws IOException {
        this.socket = new Socket(address, port);
        this.connectionHandler = ConnectionHandler.createConnectionHandler(this.socket, callHandler, filter, this.connectionHandlerListener);
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public Object getGlobal(Class<?> clazz) {
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new CallProxy(this.connectionHandler));
    }
}

