/*
 * Decompiled with CFR 0.152.
 */
package com.tapjoy;

import com.tapjoy.TapjoyLog;
import com.tapjoy.TapjoyUtil;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

public class TapjoyCachedAssetData
implements Serializable {
    private long a;
    private long b;
    private String c;
    private String d;
    private String e;
    private long f;
    private String g;
    private String h;

    public TapjoyCachedAssetData(String assetURL, String localFilePath, long timeToLiveInSeconds) {
        this(assetURL, localFilePath, timeToLiveInSeconds, System.currentTimeMillis() / 1000L);
    }

    public TapjoyCachedAssetData(String assetURL, String localFilePath, long timeToLiveInSeconds, long timestampInSeconds) {
        this.setAssetURL(assetURL);
        this.setLocalFilePath(localFilePath);
        this.b = timeToLiveInSeconds;
        this.a = timestampInSeconds;
        this.f = timestampInSeconds + timeToLiveInSeconds;
    }

    public void setAssetURL(String assetURL) {
        this.c = assetURL;
        this.g = TapjoyUtil.determineMimeType(assetURL);
    }

    public void setLocalFilePath(String localFilePath) {
        this.d = localFilePath;
        this.e = "file://" + localFilePath;
    }

    public void resetTimeToLive(long timeToLiveInSeconds) {
        this.b = timeToLiveInSeconds;
        this.f = System.currentTimeMillis() / 1000L + timeToLiveInSeconds;
    }

    public void setOfferID(String offerID) {
        this.h = offerID;
    }

    public long getTimestampInSeconds() {
        return this.a;
    }

    public long getTimeToLiveInSeconds() {
        return this.b;
    }

    public long getTimeOfDeathInSeconds() {
        return this.f;
    }

    public String getAssetURL() {
        return this.c;
    }

    public String getLocalFilePath() {
        return this.d;
    }

    public String getLocalURL() {
        return this.e;
    }

    public String getMimeType() {
        return this.g;
    }

    public String getOfferId() {
        return this.h;
    }

    public JSONObject toJSON() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("timestamp", this.getTimestampInSeconds());
            jSONObject.put("timeToLive", this.getTimeToLiveInSeconds());
            jSONObject.put("assetURL", (Object)this.getAssetURL());
            jSONObject.put("localFilePath", (Object)this.getLocalFilePath());
            jSONObject.put("offerID", (Object)this.getOfferId());
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public String toRawJSONString() {
        return this.toJSON().toString();
    }

    public static TapjoyCachedAssetData fromRawJSONString(String jsonRep) {
        try {
            return TapjoyCachedAssetData.fromJSONObject(new JSONObject(jsonRep));
        }
        catch (JSONException jSONException) {
            TapjoyLog.i("TapjoyCachedAssetData", "Can not build TapjoyVideoObject -- error reading json string");
            return null;
        }
    }

    public static TapjoyCachedAssetData fromJSONObject(JSONObject data) {
        TapjoyCachedAssetData tapjoyCachedAssetData = null;
        try {
            String string = data.getString("assetURL");
            String string2 = data.getString("localFilePath");
            long l2 = data.getLong("timestamp");
            long l3 = data.getLong("timeToLive");
            tapjoyCachedAssetData = new TapjoyCachedAssetData(string, string2, l3, l2);
            tapjoyCachedAssetData.setOfferID(data.optString("offerID"));
        }
        catch (JSONException jSONException) {
            TapjoyLog.i("TapjoyCachedAssetData", "Can not build TapjoyVideoObject -- not enough data.");
        }
        return tapjoyCachedAssetData;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nURL=").append(this.e).append("\n");
        stringBuilder.append("AssetURL=").append(this.c).append("\n");
        stringBuilder.append("MimeType=").append(this.g).append("\n");
        stringBuilder.append("Timestamp=").append(this.getTimestampInSeconds()).append("\n");
        stringBuilder.append("TimeOfDeath=").append(this.f).append("\n");
        stringBuilder.append("TimeToLive=").append(this.b).append("\n");
        return stringBuilder.toString();
    }
}

