/*
 * Decompiled with CFR 0.152.
 */
package com.tapjoy.mraid.controller;

import android.R;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import android.webkit.JavascriptInterface;
import android.webkit.URLUtil;
import com.tapjoy.TapjoyLog;
import com.tapjoy.mraid.controller.Abstract;
import com.tapjoy.mraid.util.ConfigBroadcastReceiver;
import com.tapjoy.mraid.view.MraidView;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Display
extends Abstract {
    private WindowManager c;
    private boolean d = false;
    private int e = -1;
    private int f = -1;
    private ConfigBroadcastReceiver g;
    private float h;
    private Context i;

    public Display(MraidView adView, Context c2) {
        super(adView, c2);
        this.i = c2;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.c = (WindowManager)c2.getSystemService("window");
        this.c.getDefaultDisplay().getMetrics(displayMetrics);
        this.h = displayMetrics.density;
    }

    @JavascriptInterface
    public void resize(String properties) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string2 = null;
        boolean bl2 = true;
        try {
            JSONObject jSONObject = new JSONObject(properties);
            n2 = jSONObject.getInt("width");
            n3 = jSONObject.getInt("height");
            n4 = jSONObject.getInt("offsetX");
            n5 = jSONObject.getInt("offsetY");
            string2 = jSONObject.getString("customClosePosition");
            bl2 = jSONObject.getBoolean("allowOffScreen");
        }
        catch (Exception exception) {}
        this.a.resize((int)(this.h * (float)n2), (int)(this.h * (float)n3), n4, n5, string2, bl2);
    }

    @JavascriptInterface
    public void open(String url, boolean back, boolean forward, boolean refresh) {
        TapjoyLog.i("MRAID Display", "open: url: " + url + " back: " + back + " forward: " + forward + " refresh: " + refresh);
        if (!URLUtil.isValidUrl((String)url)) {
            TapjoyLog.i("MRAID Display", "invalid URL");
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            List list = this.i.getPackageManager().queryIntentActivities(intent, 0);
            if (list.size() == 1) {
                this.i.startActivity(intent);
                return;
            }
            if (list.size() > 1) {
                Intent intent2 = Intent.createChooser((Intent)intent, (CharSequence)"Select");
                ((Activity)this.i).startActivity(intent2);
                return;
            }
            this.a.raiseError("Invalid url", "open");
            return;
        }
        this.a.open(url, back, forward, refresh);
    }

    @JavascriptInterface
    public void useCustomClose(boolean input) {
        if (input) {
            this.a.removeCloseImageButton();
            return;
        }
        if (!input) {
            this.a.showCloseImageButton();
        }
    }

    @JavascriptInterface
    public void openMap(String url, boolean fullscreen) {
        TapjoyLog.d("MRAID Display", "openMap: url: " + url);
        this.a.openMap(url, fullscreen);
    }

    @JavascriptInterface
    public void setOrientationProperties(boolean allowOrientationChange, String forceOrientation) {
        TapjoyLog.d("MRAID Display", "setOrientationProperties: allowOrientationChange: " + Boolean.toString(allowOrientationChange) + " forceOrientation: " + forceOrientation);
        this.a.setOrientationProperties(allowOrientationChange, forceOrientation);
    }

    @JavascriptInterface
    public void playAudio(String url, boolean autoPlay, boolean controls, boolean loop, boolean position, String startStyle, String stopStyle) {
        TapjoyLog.d("MRAID Display", "playAudio: url: " + url + " autoPlay: " + autoPlay + " controls: " + controls + " loop: " + loop + " position: " + position + " startStyle: " + startStyle + " stopStyle: " + stopStyle);
        if (!URLUtil.isValidUrl((String)url)) {
            this.a.raiseError("Invalid url", "playAudio");
            return;
        }
        this.a.playAudio(url, autoPlay, controls, loop, position, startStyle, stopStyle);
    }

    @JavascriptInterface
    public void playVideo(String url, boolean audioMuted, boolean autoPlay, boolean controls, boolean loop, int[] position, String startStyle, String stopStyle) {
        TapjoyLog.d("MRAID Display", "playVideo: url: " + url + " audioMuted: " + audioMuted + " autoPlay: " + autoPlay + " controls: " + controls + " loop: " + loop + " x: " + position[0] + " y: " + position[1] + " width: " + position[2] + " height: " + position[3] + " startStyle: " + startStyle + " stopStyle: " + stopStyle);
        Abstract.Dimensions dimensions = null;
        if (position[0] != -1) {
            dimensions = new Abstract.Dimensions();
            new Abstract.Dimensions().x = position[0];
            dimensions.y = position[1];
            dimensions.width = position[2];
            dimensions.height = position[3];
            dimensions = this.a(dimensions);
        }
        int n2 = 0;
        if (url.contains("android.resource")) {
            int n3 = url.lastIndexOf("/") + 1;
            int n4 = url.lastIndexOf(".");
            String string2 = url.substring(n3, n4);
            try {
                n2 = R.raw.class.getField(string2).getInt(null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            String string3 = this.b.getPackageName();
            url = "android.resource://" + string3 + "/" + n2;
        }
        this.a.playVideo(url, false, true, true, false, dimensions, "fullscreen", "exit");
    }

    private Abstract.Dimensions a(Abstract.Dimensions dimensions) {
        dimensions.width = (int)Math.ceil(this.h * (float)dimensions.width);
        dimensions.height = (int)Math.ceil(this.h * (float)dimensions.height);
        dimensions.x = (int)((float)dimensions.x * this.h);
        dimensions.y = (int)((float)dimensions.y * this.h);
        if (dimensions.height < 0) {
            dimensions.height = this.a.getHeight();
        }
        if (dimensions.width < 0) {
            dimensions.width = this.a.getWidth();
        }
        int[] nArray = new int[2];
        this.a.getLocationInWindow(nArray);
        if (dimensions.x < 0) {
            dimensions.x = nArray[0];
        }
        if (dimensions.y < 0) {
            dimensions.y = nArray[1] - 0;
        }
        return dimensions;
    }

    @JavascriptInterface
    public void expand(String URL2, String properties) {
        TapjoyLog.d("MRAID Display", "expand: properties: " + properties + " url: " + URL2);
        try {
            JSONObject jSONObject = new JSONObject(properties);
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("width", jSONObject.get("width"));
            jSONObject2.put("height", jSONObject.get("height"));
            jSONObject2.put("x", 0);
            jSONObject2.put("y", 0);
            Abstract.Dimensions dimensions = (Abstract.Dimensions)Display.a(jSONObject2, Abstract.Dimensions.class);
            this.a.expand(this.a(dimensions), URL2, (Abstract.Properties)Display.a(new JSONObject(properties), Abstract.Properties.class));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return;
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return;
        }
    }

    @JavascriptInterface
    public void close() {
        TapjoyLog.d("MRAID Display", "close");
        this.a.close();
    }

    @JavascriptInterface
    public void hide() {
        TapjoyLog.d("MRAID Display", "hide");
        this.a.hide();
    }

    @JavascriptInterface
    public void show() {
        TapjoyLog.d("MRAID Display", "show");
        this.a.show();
    }

    public boolean isVisible() {
        return this.a.getVisibility() == 0;
    }

    public String dimensions() {
        return "{ \"top\" :" + (int)((float)this.a.getTop() / this.h) + ",\"left\" :" + (int)((float)this.a.getLeft() / this.h) + ",\"bottom\" :" + (int)((float)this.a.getBottom() / this.h) + ",\"right\" :" + (int)((float)this.a.getRight() / this.h) + "}";
    }

    public int getOrientation() {
        int n2 = this.c.getDefaultDisplay().getOrientation();
        int n3 = -1;
        switch (n2) {
            case 0: {
                n3 = 0;
                break;
            }
            case 1: {
                n3 = 90;
                break;
            }
            case 2: {
                n3 = 180;
                break;
            }
            case 3: {
                n3 = 270;
            }
        }
        TapjoyLog.d("MRAID Display", "getOrientation: " + n3);
        return n3;
    }

    public String getScreenSize() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.c.getDefaultDisplay().getMetrics(displayMetrics);
        return "{ width: " + (int)Math.ceil((float)displayMetrics.widthPixels / displayMetrics.density) + ", height: " + (int)Math.ceil((float)displayMetrics.heightPixels / displayMetrics.density) + "}";
    }

    public String getSize() {
        return this.a.getSize();
    }

    public String getMaxSize() {
        if (this.d) {
            return "{ width: " + this.e + ", height: " + this.f + "}";
        }
        return this.getScreenSize();
    }

    public void setMaxSize(int w2, int h2) {
        TapjoyLog.d("MRAID Display", "setMaxSize: " + w2 + "x" + h2);
        this.d = true;
        this.e = w2;
        this.f = h2;
    }

    public void onOrientationChanged(int orientation) {
        String string2 = "window.mraidview.fireChangeEvent({ orientation: " + orientation + "});";
        TapjoyLog.d("MRAID Display", string2);
        this.a.injectMraidJavaScript(string2);
    }

    public void logHTML(String html) {
        TapjoyLog.d("MRAID Display", html);
    }

    @Override
    public void stopAllListeners() {
        this.stopConfigurationListener();
        this.g = null;
    }

    public void stopConfigurationListener() {
        try {
            this.b.unregisterReceiver((BroadcastReceiver)this.g);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void startConfigurationListener() {
        try {
            if (this.g == null) {
                this.g = new ConfigBroadcastReceiver(this);
            }
            this.b.registerReceiver((BroadcastReceiver)this.g, new IntentFilter("android.intent.action.CONFIGURATION_CHANGED"));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

