/*
 * Decompiled with CFR 0.152.
 */
package com.tapjoy;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import com.tapjoy.TapjoyConnectCore;
import com.tapjoy.TapjoyLog;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TapjoyUtil {
    private static String a = null;
    private static HashMap b = new HashMap();

    public static String SHA1(String text) {
        return TapjoyUtil.a("SHA-1", text);
    }

    public static String SHA256(String text) {
        return TapjoyUtil.a("SHA-256", text);
    }

    private static String a(String string, String string2) {
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        messageDigest.update(string2.getBytes("iso-8859-1"), 0, string2.length());
        byte[] byArray = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] >>> 4 & 0xF;
            int n3 = 0;
            do {
                if (n2 >= 0 && n2 <= 9) {
                    stringBuffer.append((char)(48 + n2));
                } else {
                    stringBuffer.append((char)(97 + (n2 - 10)));
                }
                n2 = byArray[i2] & 0xF;
            } while (n3++ <= 0);
        }
        return stringBuffer.toString();
    }

    public static Document buildDocument(String xml) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            document = documentBuilderFactory.newDocumentBuilder().parse(byteArrayInputStream);
        }
        catch (Exception exception) {
            TapjoyLog.e("TapjoyUtil", "buildDocument exception: " + exception.toString());
        }
        return document;
    }

    public static String getNodeTrimValue(NodeList nodeList) {
        Element element = (Element)nodeList.item(0);
        String string = "";
        if (element != null) {
            NodeList nodeList2 = element.getChildNodes();
            int n2 = nodeList2.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                Node node = nodeList2.item(i2);
                if (node == null) continue;
                string = string + node.getNodeValue();
            }
            if (string != null && !string.equals("")) {
                return string.trim();
            }
            return null;
        }
        return null;
    }

    public static void deleteFileOrDirectory(File fileOrDirectory) {
        File[] fileArray;
        if (fileOrDirectory == null) {
            return;
        }
        if (fileOrDirectory.isDirectory() && (fileArray = fileOrDirectory.listFiles()) != null && fileArray.length > 0) {
            File[] fileArray2 = fileArray;
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                TapjoyUtil.deleteFileOrDirectory(fileArray2[i2]);
            }
        }
        TapjoyLog.d("TapjoyUtil", "****************************************");
        TapjoyLog.d("TapjoyUtil", "deleteFileOrDirectory: " + fileOrDirectory.getAbsolutePath());
        TapjoyLog.d("TapjoyUtil", "****************************************");
        fileOrDirectory.delete();
    }

    public static long fileOrDirectorySize(File fileOrDirectory) {
        long l2 = 0L;
        for (File file : fileOrDirectory.listFiles()) {
            if (file.isFile()) {
                l2 += file.length();
                continue;
            }
            l2 += TapjoyUtil.fileOrDirectorySize(file);
        }
        return l2;
    }

    public static void writeFileToDevice(BufferedInputStream inputStream, OutputStream outputStream) {
        int n2;
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public static Bitmap createBitmapFromView(View v2) {
        Bitmap bitmap = null;
        if (v2 != null && v2.getLayoutParams().width > 0 && v2.getLayoutParams().height > 0) {
            try {
                bitmap = Bitmap.createBitmap((int)v2.getLayoutParams().width, (int)v2.getLayoutParams().height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                v2.layout(v2.getLeft(), v2.getTop(), v2.getRight(), v2.getBottom());
                v2.draw(canvas);
            }
            catch (Exception exception) {
                TapjoyLog.d("TapjoyUtil", "error creating bitmap: " + exception.toString());
            }
        }
        return bitmap;
    }

    public static View scaleDisplayAd(View adView, int targetWidth) {
        int n2 = adView.getLayoutParams().width;
        int n3 = adView.getLayoutParams().height;
        TapjoyLog.d("TapjoyUtil", "wxh: " + n2 + "x" + n3);
        if (n2 > targetWidth) {
            int n4 = Double.valueOf(Double.valueOf(Double.valueOf(targetWidth) / Double.valueOf(n2)) * 100.0).intValue();
            ((WebView)adView).getSettings().setSupportZoom(true);
            ((WebView)adView).setPadding(0, 0, 0, 0);
            ((WebView)adView).setVerticalScrollBarEnabled(false);
            ((WebView)adView).setHorizontalScrollBarEnabled(false);
            ((WebView)adView).setInitialScale(n4);
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(targetWidth, targetWidth * n3 / n2);
            adView.setLayoutParams(layoutParams);
        }
        return adView;
    }

    public static void safePut(Map map, String key, String value, boolean encode) {
        if (key != null && key.length() > 0 && value != null && value.length() > 0) {
            if (encode) {
                map.put(Uri.encode((String)key), Uri.encode((String)value));
                return;
            }
            map.put(key, value);
        }
    }

    public static String convertURLParams(Map source, boolean encode) {
        String string = "";
        for (Map.Entry entry : source.entrySet()) {
            if (string.length() > 0) {
                string = string + "&";
            }
            if (encode) {
                string = string + Uri.encode((String)((String)entry.getKey())) + "=" + Uri.encode((String)((String)entry.getValue()));
                continue;
            }
            string = string + (String)entry.getKey() + "=" + (String)entry.getValue();
        }
        return string;
    }

    public static Map convertURLParams(String source, boolean decode) {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl2 = false;
        String string2 = "";
        String string3 = "";
        for (int i2 = 0; i2 < source.length() && i2 != -1; ++i2) {
            char c2 = source.charAt(i2);
            if (!bl2) {
                if (c2 == '=') {
                    bl2 = true;
                    string3 = decode ? Uri.decode((String)string2) : string2;
                    string2 = "";
                    continue;
                }
                string2 = string2 + c2;
                continue;
            }
            if (!bl2) continue;
            if (c2 == '&') {
                bl2 = false;
                string = decode ? Uri.decode((String)string2) : string2;
                string2 = "";
                hashMap.put(string3, string);
                continue;
            }
            string2 = string2 + c2;
        }
        if (bl2 && string2.length() > 0) {
            string = decode ? Uri.decode((String)string2) : string2;
            hashMap.put(string3, string);
        }
        return hashMap;
    }

    public static String copyTextFromJarIntoString(String source) {
        return TapjoyUtil.copyTextFromJarIntoString(source, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Bitmap loadBitmapFromJar(String source, Context context) {
        var2_2 = null;
        var3_3 = new BitmapFactory.Options();
        new BitmapFactory.Options().inJustDecodeBounds = true;
        var4_4 = (byte[])TapjoyUtil.getResource(source);
        if (var4_4 != null) {
            BitmapFactory.decodeByteArray((byte[])var4_4, (int)0, (int)var4_4.length, (BitmapFactory.Options)var3_3);
            var2_2 = BitmapFactory.decodeByteArray((byte[])var4_4, (int)0, (int)var4_4.length);
        }
        if (var2_2 == null) {
            var5_5 = null;
            source = "com/tapjoy/res/" + source;
            try {
                var6_7 = TapjoyUtil.class.getClassLoader().getResource(source);
                if (var6_7 == null) {
                    var7_8 = context.getAssets();
                    var5_5 = var7_8.open(source);
                    BitmapFactory.decodeStream((InputStream)var5_5, null, (BitmapFactory.Options)var3_3);
                    var5_5 = var7_8.open(source);
                } else {
                    var7_9 = var6_7.getFile();
                    if (var7_9.startsWith("jar:")) {
                        var7_9 = var7_9.substring(4);
                    }
                    if (var7_9.startsWith("file:")) {
                        var7_9 = var7_9.substring(5);
                    }
                    if ((var8_10 = var7_9.indexOf("!")) > 0) {
                        var7_9 = var7_9.substring(0, var8_10);
                    }
                    var9_11 = new JarFile(var7_9);
                    var10_12 = var9_11.getJarEntry(source);
                    var5_5 = var9_11.getInputStream(var10_12);
                    BitmapFactory.decodeStream((InputStream)var5_5, null, (BitmapFactory.Options)var3_3);
                    var5_5 = var9_11.getInputStream(var10_12);
                }
                var2_2 = BitmapFactory.decodeStream((InputStream)var5_5);
                ** if (var5_5 == null) goto lbl-1000
            }
            catch (Exception v1) {
                block20: {
                    try {
                        v1.printStackTrace();
                        if (var5_5 == null) break block20;
                    }
                    catch (Throwable var11_13) {
                        if (var5_5 != null) {
                            try {
                                var5_5.close();
                            }
                            catch (IOException v2) {}
                        }
                        throw var11_13;
                    }
                    try {
                        var5_5.close();
                    }
                    catch (IOException v3) {}
                }
                return null;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var5_5.close();
                }
                catch (IOException v0) {}
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        var5_6 = TapjoyConnectCore.getDeviceScreenDensityScale();
        if (var2_2 != null) {
            var2_2 = Bitmap.createScaledBitmap((Bitmap)var2_2, (int)((int)((float)var3_3.outWidth * var5_6)), (int)((int)((float)var3_3.outHeight * var5_6)), (boolean)true);
        }
        return var2_2;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String copyTextFromJarIntoString(String source, Context context) {
        int n2;
        byte[] byArray = new byte[1024];
        StringBuffer stringBuffer = new StringBuffer();
        InputStream inputStream = null;
        URL uRL = TapjoyUtil.class.getClassLoader().getResource(source);
        if (context != null && uRL == null) {
            inputStream = context.getAssets().open(source);
        } else {
            int n3;
            String string = uRL.getFile();
            if (string.startsWith("jar:")) {
                string = string.substring(4);
            }
            if (string.startsWith("file:")) {
                string = string.substring(5);
            }
            if ((n3 = string.indexOf("!")) > 0) {
                string = string.substring(0, n3);
            }
            JarFile jarFile = new JarFile(string);
            JarEntry jarEntry = jarFile.getJarEntry(source);
            inputStream = jarFile.getInputStream(jarEntry);
        }
        while ((n2 = inputStream.read(byArray)) > 0) {
            String string = new String(byArray);
            stringBuffer.append(string.substring(0, n2));
        }
        String string = stringBuffer.toString();
        if (inputStream == null) return string;
        try {
            inputStream.close();
            return string;
        }
        catch (Exception exception) {}
        return string;
        catch (Exception exception) {
            try {
                TapjoyLog.d("TapjoyUtil", "file exception: " + exception.toString());
                exception.printStackTrace();
                if (inputStream == null) return null;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                inputStream.close();
                return null;
            }
            catch (Exception exception3) {}
            return null;
        }
    }

    public static void setResource(String key, Object value) {
        b.put(key, value);
    }

    public static Object getResource(String key) {
        return b.get(key);
    }

    public static String getRedirectDomain(String hostURL) {
        String string = "";
        if (hostURL != null) {
            string = hostURL.substring(hostURL.indexOf("//") + 2, hostURL.lastIndexOf("/"));
        }
        return string;
    }

    public static String determineMimeType(String url) {
        String string = "";
        if (url.endsWith(".")) {
            url = url.substring(0, url.length() - 1);
        }
        if (url.lastIndexOf(46) != -1) {
            string = url.substring(url.lastIndexOf(46) + 1);
        }
        String string2 = string.equals("css") ? "text/css" : (string.equals("js") ? "text/javascript" : (string.equals("html") ? "text/html" : "application/octet-stream"));
        return string2;
    }

    public static Map jsonToStringMap(JSONObject json) {
        Map map = new HashMap();
        if (json != JSONObject.NULL) {
            map = TapjoyUtil.toStringMap(json);
        }
        return map;
    }

    public static Map toStringMap(JSONObject object) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = object.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = object.get(string).toString();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public static void runOnMainThread(Runnable task) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            task.run();
            return;
        }
        new Handler(Looper.getMainLooper()).post(task);
    }
}

