/*
 * Decompiled with CFR 0.152.
 */
package com.tapjoy.mraid.controller;

import android.annotation.TargetApi;
import android.content.Context;
import android.webkit.JavascriptInterface;
import com.tapjoy.TapjoyLog;
import com.tapjoy.mraid.controller.Abstract;
import com.tapjoy.mraid.controller.Assets;
import com.tapjoy.mraid.controller.Display;
import com.tapjoy.mraid.controller.MraidLocation;
import com.tapjoy.mraid.controller.MraidSensor;
import com.tapjoy.mraid.controller.Network;
import com.tapjoy.mraid.view.MraidView;

@TargetApi(value=14)
public class Utility
extends Abstract {
    private Assets c;
    private Display d;
    private MraidLocation e;
    private Network f;
    private MraidSensor g;

    public Utility(MraidView adView, Context context) {
        super(adView, context);
        this.c = new Assets(adView, context);
        this.d = new Display(adView, context);
        this.e = new MraidLocation(adView, context);
        this.f = new Network(adView, context);
        this.g = new MraidSensor(adView, context);
        adView.addJavascriptInterface(this.c, "MRAIDAssetsControllerBridge");
        adView.addJavascriptInterface(this.d, "MRAIDDisplayControllerBridge");
        adView.addJavascriptInterface(this.e, "MRAIDLocationControllerBridge");
        adView.addJavascriptInterface(this.f, "MRAIDNetworkControllerBridge");
        adView.addJavascriptInterface(this.g, "MRAIDSensorControllerBridge");
    }

    public void init(float density) {
        StringBuilder stringBuilder = new StringBuilder("window.mraidview.fireChangeEvent({ state: 'default', network: '").append(this.f.getNetwork()).append("', size: ").append(this.d.getSize()).append(", placement: '").append((Object)this.a.getPlacementType()).append("', maxSize: ").append(this.d.getMaxSize()).append(",expandProperties: ").append(this.d.getMaxSize()).append(", screenSize: ").append(this.d.getScreenSize()).append(", defaultPosition: { x:").append((int)((float)this.a.getLeft() / density)).append(", y: ").append((int)((float)this.a.getTop() / density)).append(", width: ").append((int)((float)this.a.getWidth() / density)).append(", height: ").append((int)((float)this.a.getHeight() / density)).append(" }, orientation:").append(this.d.getOrientation()).append(",");
        Utility utility = this;
        String string2 = "supports: [ 'level-1', 'level-2', 'screen', 'orientation', 'network'";
        if (utility.e.allowLocationServices() && (utility.b.checkCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0 || utility.b.checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0)) {
            string2 = string2 + ", 'location'";
        }
        string2 = string2 + ", 'video'";
        string2 = string2 + ", 'audio'";
        string2 = string2 + ", 'map' ]";
        TapjoyLog.d("MRAID Utility", "getSupports: " + string2);
        String string3 = stringBuilder.append(string2).append(",viewable:true });").toString();
        TapjoyLog.d("MRAID Utility", "init: injection: " + string3);
        this.a.injectMraidJavaScript(string3);
        this.fireReadyEvent();
        this.fireViewableChange(true);
    }

    public void fireReadyEvent() {
        this.a.injectMraidJavaScript("mraid.signalReady();");
    }

    public void fireViewableChange(boolean visible) {
        this.a.injectMraidJavaScript("window.mraidview.fireChangeEvent({viewable:" + visible + "});");
    }

    public String copyTextFromJarIntoAssetDir(String alias, String source) {
        return this.c.copyTextFromJarIntoAssetDir(alias, source);
    }

    public void setMaxSize(int w2, int h2) {
        this.d.setMaxSize(w2, h2);
    }

    @JavascriptInterface
    public void activate(String event) {
        TapjoyLog.d("MRAID Utility", "activate: " + event);
        if (event.equalsIgnoreCase("networkChange")) {
            this.f.startNetworkListener();
            return;
        }
        if (this.e.allowLocationServices() && event.equalsIgnoreCase("locationChange")) {
            this.e.startLocationListener();
            return;
        }
        if (event.equalsIgnoreCase("shake")) {
            this.g.startShakeListener();
            return;
        }
        if (event.equalsIgnoreCase("tiltChange")) {
            this.g.startTiltListener();
            return;
        }
        if (event.equalsIgnoreCase("headingChange")) {
            this.g.startHeadingListener();
            return;
        }
        if (event.equalsIgnoreCase("orientationChange")) {
            this.d.startConfigurationListener();
        }
    }

    @JavascriptInterface
    public void deactivate(String event) {
        TapjoyLog.d("MRAID Utility", "deactivate: " + event);
        if (event.equalsIgnoreCase("networkChange")) {
            this.f.stopNetworkListener();
            return;
        }
        if (event.equalsIgnoreCase("locationChange")) {
            this.e.stopAllListeners();
            return;
        }
        if (event.equalsIgnoreCase("shake")) {
            this.g.stopShakeListener();
            return;
        }
        if (event.equalsIgnoreCase("tiltChange")) {
            this.g.stopTiltListener();
            return;
        }
        if (event.equalsIgnoreCase("headingChange")) {
            this.g.stopHeadingListener();
            return;
        }
        if (event.equalsIgnoreCase("orientationChange")) {
            this.d.stopConfigurationListener();
        }
    }

    public void deleteOldAds() {
        this.c.deleteOldAds();
    }

    @Override
    public void stopAllListeners() {
        try {
            this.c.stopAllListeners();
            this.d.stopAllListeners();
            this.e.stopAllListeners();
            this.f.stopAllListeners();
            this.g.stopAllListeners();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @JavascriptInterface
    public void showAlert(String message) {
        TapjoyLog.e("MRAID Utility", message);
    }
}

