/*
 * Decompiled with CFR 0.152.
 */
package com.tapjoy.mraid.controller;

import android.R;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import android.webkit.JavascriptInterface;
import android.webkit.URLUtil;
import com.tapjoy.TapjoyLog;
import com.tapjoy.mraid.controller.Abstract;
import com.tapjoy.mraid.util.ConfigBroadcastReceiver;
import com.tapjoy.mraid.view.MraidView;
import java.util.List;

public class Display
extends Abstract {
    private WindowManager c;
    private boolean d = false;
    private int e = -1;
    private int f = -1;
    private ConfigBroadcastReceiver g;
    private float h;
    private Context i;

    public Display(MraidView adView, Context c2) {
        super(adView, c2);
        this.i = c2;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.c = (WindowManager)c2.getSystemService("window");
        this.c.getDefaultDisplay().getMetrics(displayMetrics);
        this.h = displayMetrics.density;
    }

    @JavascriptInterface
    public void open(String url, boolean back, boolean forward, boolean refresh) {
        TapjoyLog.i("MRAID Display", "open: url: " + url + " back: " + back + " forward: " + forward + " refresh: " + refresh);
        if (!URLUtil.isValidUrl((String)url)) {
            TapjoyLog.i("MRAID Display", "invalid URL");
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            List list = this.i.getPackageManager().queryIntentActivities(intent, 0);
            if (list.size() == 1) {
                this.i.startActivity(intent);
                return;
            }
            if (list.size() > 1) {
                Intent intent2 = Intent.createChooser((Intent)intent, (CharSequence)"Select");
                ((Activity)this.i).startActivity(intent2);
                return;
            }
            this.a.raiseError("Invalid url", "open");
            return;
        }
        this.a.open(url, back, forward, refresh);
    }

    @JavascriptInterface
    public void useCustomClose(boolean input) {
        if (input) {
            this.a.removeCloseImageButton();
            return;
        }
        if (!input) {
            this.a.showCloseImageButton();
        }
    }

    @JavascriptInterface
    public void openMap(String url, boolean fullscreen) {
        TapjoyLog.d("MRAID Display", "openMap: url: " + url);
        this.a.openMap(url, fullscreen);
    }

    @JavascriptInterface
    public void setOrientationProperties(boolean allowOrientationChange, String forceOrientation) {
        TapjoyLog.d("MRAID Display", "setOrientationProperties: allowOrientationChange: " + Boolean.toString(allowOrientationChange) + " forceOrientation: " + forceOrientation);
        this.a.setOrientationProperties(allowOrientationChange, forceOrientation);
    }

    @JavascriptInterface
    public void playAudio(String url, boolean autoPlay, boolean controls, boolean loop, boolean position, String startStyle, String stopStyle) {
        TapjoyLog.d("MRAID Display", "playAudio: url: " + url + " autoPlay: " + autoPlay + " controls: " + controls + " loop: " + loop + " position: " + position + " startStyle: " + startStyle + " stopStyle: " + stopStyle);
        if (!URLUtil.isValidUrl((String)url)) {
            this.a.raiseError("Invalid url", "playAudio");
            return;
        }
        this.a.playAudio(url, autoPlay, controls, loop, position, startStyle, stopStyle);
    }

    @JavascriptInterface
    public void playVideo(String url, boolean audioMuted, boolean autoPlay, boolean controls, boolean loop, int[] position, String startStyle, String stopStyle) {
        TapjoyLog.d("MRAID Display", "playVideo: url: " + url + " audioMuted: " + audioMuted + " autoPlay: " + autoPlay + " controls: " + controls + " loop: " + loop + " x: " + position[0] + " y: " + position[1] + " width: " + position[2] + " height: " + position[3] + " startStyle: " + startStyle + " stopStyle: " + stopStyle);
        Abstract.Dimensions dimensions = null;
        if (position[0] != -1) {
            dimensions = new Abstract.Dimensions();
            new Abstract.Dimensions().x = position[0];
            dimensions.y = position[1];
            dimensions.width = position[2];
            dimensions.height = position[3];
            Abstract.Dimensions dimensions2 = dimensions;
            Display display = this;
            dimensions2.width = (int)Math.ceil(display.h * (float)dimensions2.width);
            dimensions2.height = (int)Math.ceil(display.h * (float)dimensions2.height);
            dimensions2.x = (int)((float)dimensions2.x * display.h);
            dimensions2.y = (int)((float)dimensions2.y * display.h);
            if (dimensions2.height < 0) {
                dimensions2.height = display.a.getHeight();
            }
            if (dimensions2.width < 0) {
                dimensions2.width = display.a.getWidth();
            }
            int[] nArray = new int[2];
            display.a.getLocationInWindow(nArray);
            if (dimensions2.x < 0) {
                dimensions2.x = nArray[0];
            }
            if (dimensions2.y < 0) {
                dimensions2.y = nArray[1] - 0;
            }
            dimensions = dimensions2;
        }
        int n2 = 0;
        if (url.contains("android.resource")) {
            int n3 = url.lastIndexOf("/") + 1;
            int n4 = url.lastIndexOf(".");
            String string2 = url.substring(n3, n4);
            try {
                n2 = R.raw.class.getField(string2).getInt(null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            String string3 = this.b.getPackageName();
            url = "android.resource://" + string3 + "/" + n2;
        }
        this.a.playVideo(url, false, true, true, false, dimensions, "fullscreen", "exit");
    }

    @JavascriptInterface
    public void close() {
        TapjoyLog.d("MRAID Display", "close");
        this.a.close();
    }

    @JavascriptInterface
    public void show() {
        TapjoyLog.d("MRAID Display", "show");
        this.a.show();
    }

    public boolean isVisible() {
        return this.a.getVisibility() == 0;
    }

    public String dimensions() {
        return "{ \"top\" :" + (int)((float)this.a.getTop() / this.h) + ",\"left\" :" + (int)((float)this.a.getLeft() / this.h) + ",\"bottom\" :" + (int)((float)this.a.getBottom() / this.h) + ",\"right\" :" + (int)((float)this.a.getRight() / this.h) + "}";
    }

    public int getOrientation() {
        int n2 = this.c.getDefaultDisplay().getOrientation();
        int n3 = -1;
        switch (n2) {
            case 0: {
                n3 = 0;
                break;
            }
            case 1: {
                n3 = 90;
                break;
            }
            case 2: {
                n3 = 180;
                break;
            }
            case 3: {
                n3 = 270;
            }
        }
        TapjoyLog.d("MRAID Display", "getOrientation: " + n3);
        return n3;
    }

    public String getScreenSize() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.c.getDefaultDisplay().getMetrics(displayMetrics);
        return "{ width: " + (int)Math.ceil((float)displayMetrics.widthPixels / displayMetrics.density) + ", height: " + (int)Math.ceil((float)displayMetrics.heightPixels / displayMetrics.density) + "}";
    }

    public String getSize() {
        return this.a.getSize();
    }

    public String getMaxSize() {
        if (this.d) {
            return "{ width: " + this.e + ", height: " + this.f + "}";
        }
        return this.getScreenSize();
    }

    public void setMaxSize(int w2, int h2) {
        TapjoyLog.d("MRAID Display", "setMaxSize: " + w2 + "x" + h2);
        this.d = true;
        this.e = w2;
        this.f = h2;
    }

    public void onOrientationChanged(int orientation) {
        String string2 = "window.mraidview.fireChangeEvent({ orientation: " + orientation + "});";
        TapjoyLog.d("MRAID Display", string2);
        this.a.injectMraidJavaScript(string2);
    }

    public void logHTML(String html) {
        TapjoyLog.d("MRAID Display", html);
    }

    @Override
    public void stopAllListeners() {
        this.stopConfigurationListener();
        this.g = null;
    }

    public void stopConfigurationListener() {
        try {
            this.b.unregisterReceiver((BroadcastReceiver)this.g);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void startConfigurationListener() {
        try {
            if (this.g == null) {
                this.g = new ConfigBroadcastReceiver(this);
            }
            this.b.registerReceiver((BroadcastReceiver)this.g, new IntentFilter("android.intent.action.CONFIGURATION_CHANGED"));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

