/*
 * Decompiled with CFR 0.152.
 */
package com.tapjoy.mraid.controller;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Environment;
import android.os.StatFs;
import android.webkit.JavascriptInterface;
import com.tapjoy.TapjoyLog;
import com.tapjoy.internal.da;
import com.tapjoy.internal.em;
import com.tapjoy.mraid.controller.Abstract;
import com.tapjoy.mraid.view.MraidView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Assets
extends Abstract {
    private int c = 0;
    private static final char[] d = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public Assets(MraidView adView, Context c2) {
        super(adView, c2);
    }

    @JavascriptInterface
    public void storePictureInit(String URI2) {
        final String string2 = URI2;
        AlertDialog.Builder builder = new AlertDialog.Builder(this.b);
        builder.setMessage((CharSequence)("Are you sure you want to save file from " + URI2 + " to your SD card?"));
        builder.setCancelable(false);
        builder.setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public final void onClick(DialogInterface dialog, int id2) {
                Assets.this.storePicture(string2);
            }
        });
        builder.setNegativeButton((CharSequence)"No", null);
        builder.show();
    }

    public void storePicture(String URI2) {
        TapjoyLog.d("MRAID Assets", "Storing media from " + URI2 + " to device photo album.  Output directory: " + Environment.getExternalStorageDirectory() + " state: " + Environment.getExternalStorageState());
        ++this.c;
        try {
            URL uRL = new URL(URI2);
            String string2 = "MraidMedia" + this.c + ".jpg";
            File file = new File(Environment.getExternalStorageDirectory().toString() + "/" + string2);
            long l2 = System.currentTimeMillis();
            TapjoyLog.d("MRAID Assets", "download beginning");
            TapjoyLog.d("MRAID Assets", "download url:" + uRL);
            TapjoyLog.d("MRAID Assets", "downloaded file name:" + string2);
            InputStream inputStream = em.a(uRL).getInputStream();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            da.a(inputStream, fileOutputStream);
            fileOutputStream.close();
            TapjoyLog.d("MRAID Assets", "download ready in" + (System.currentTimeMillis() - l2) / 1000L + " sec");
            return;
        }
        catch (IOException iOException) {
            TapjoyLog.d("MRAID Assets", "Error: " + iOException);
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String copyTextFromJarIntoAssetDir(String alias, String source) {
        InputStream inputStream = null;
        URL uRL = Assets.class.getClassLoader().getResource(source);
        if (uRL == null) {
            inputStream = this.b.getAssets().open(source);
        } else {
            int n2;
            String string2 = uRL.getFile();
            if (string2.startsWith("jar:")) {
                string2 = string2.substring(4);
            }
            if (string2.startsWith("file:")) {
                string2 = string2.substring(5);
            }
            if ((n2 = string2.indexOf("!")) > 0) {
                string2 = string2.substring(0, n2);
            }
            JarFile jarFile = new JarFile(string2);
            JarEntry jarEntry = jarFile.getJarEntry(source);
            inputStream = jarFile.getInputStream(jarEntry);
        }
        String string3 = this.writeToDisk(inputStream, alias, false);
        if (inputStream == null) return string3;
        try {
            inputStream.close();
            return string3;
        }
        catch (Exception exception) {}
        return string3;
        catch (Exception exception) {
            try {
                TapjoyLog.e("MRAID Assets", "copyTextFromJarIntoAssetDir: " + exception.toString());
                if (inputStream == null) return null;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                inputStream.close();
                return null;
            }
            catch (Exception exception3) {}
            return null;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addAsset(String alias, String url) {
        InputStream inputStream = null;
        inputStream = em.a(url);
        this.writeToDisk(inputStream, alias, false);
        String string2 = "MraidAdController.addedAsset('" + alias + "' )";
        this.a.injectMraidJavaScript(string2);
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                if (inputStream == null) return;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                inputStream.close();
                return;
            }
            catch (Exception exception3) {
                return;
            }
        }
    }

    public int cacheRemaining() {
        File file = this.b.getFilesDir();
        StatFs statFs = new StatFs(file.getPath());
        return statFs.getFreeBlocks() * statFs.getBlockSize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String writeToDisk(InputStream in, String file, boolean storeInHashedDirectory) {
        MessageDigest messageDigest;
        block13: {
            byte[] byArray = new byte[1024];
            messageDigest = null;
            if (storeInHashedDirectory) {
                try {
                    messageDigest = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    noSuchAlgorithmException.printStackTrace();
                }
            }
            FileOutputStream fileOutputStream = null;
            try {
                int n2;
                fileOutputStream = this.getAssetOutputString(file);
                while ((n2 = in.read(byArray)) > 0) {
                    if (storeInHashedDirectory && messageDigest != null) {
                        messageDigest.update(byArray);
                    }
                    fileOutputStream.write(byArray, 0, n2);
                }
                fileOutputStream.flush();
                if (fileOutputStream == null) break block13;
            }
            catch (Throwable throwable) {
                if (fileOutputStream == null) throw throwable;
                try {
                    fileOutputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
        String string2 = this.a();
        if (!storeInHashedDirectory) return string2 + file;
        if (messageDigest == null) return string2 + file;
        byte[] byArray = messageDigest.digest();
        char[] cArray = new char[byArray.length * 2];
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n3 >= byArray.length) {
                String string3 = new String(cArray);
                String string4 = string2;
                String string5 = file;
                File file2 = new File(string4 + File.separator + string5);
                new File(string4 + File.separator + "ad").mkdir();
                File file3 = new File(string4 + File.separator + "ad" + File.separator + string3);
                file3.mkdir();
                file2.renameTo(new File(file3, file2.getName()));
                string2 = file3.getPath() + File.separator;
                return string2 + file;
            }
            cArray[n4++] = d[byArray[n3] >>> 4 & 0xF];
            cArray[n4++] = d[byArray[n3] & 0xF];
            ++n3;
        }
    }

    private String a() {
        return this.b.getFilesDir().getPath();
    }

    public FileOutputStream getAssetOutputString(String asset) {
        File file = this.a(Assets.b(asset));
        file.mkdirs();
        File file2 = new File(file, Assets.c(asset));
        return new FileOutputStream(file2);
    }

    public void removeAsset(String asset) {
        File file = this.a(Assets.b(asset));
        file.mkdirs();
        new File(file, Assets.c(asset)).delete();
        String string2 = "MraidAdController.assetRemoved('" + asset + "' )";
        this.a.injectMraidJavaScript(string2);
    }

    private File a(String string2) {
        File file = this.b.getFilesDir();
        return new File(file.getPath() + File.separator + string2);
    }

    private static String b(String string2) {
        int n2 = string2.lastIndexOf(File.separatorChar);
        String string3 = "/";
        if (n2 >= 0) {
            string3 = string2.substring(0, string2.lastIndexOf(File.separatorChar));
        }
        return string3;
    }

    private static String c(String string2) {
        int n2 = string2.lastIndexOf(File.separatorChar);
        String string3 = string2;
        if (n2 >= 0) {
            string3 = string2.substring(string2.lastIndexOf(File.separatorChar) + 1);
        }
        return string3;
    }

    public String getAssetPath() {
        return "file://" + this.b.getFilesDir() + "/";
    }

    public static boolean deleteDirectory(String path) {
        if (path != null) {
            return Assets.deleteDirectory(new File(path));
        }
        return false;
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] fileArray = path.listFiles();
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (fileArray[i2].isDirectory()) {
                    Assets.deleteDirectory(fileArray[i2]);
                    continue;
                }
                fileArray[i2].delete();
            }
        }
        return path.delete();
    }

    public void deleteOldAds() {
        String string2 = this.a();
        Assets.deleteDirectory(new File(string2 + File.separator + "ad"));
    }

    @Override
    public void stopAllListeners() {
    }
}

