/*
 * Decompiled with CFR 0.152.
 */
package com.tapjoy;

import android.content.Context;
import android.content.SharedPreferences;
import com.tapjoy.TapjoyCachedAssetData;
import com.tapjoy.TapjoyLog;
import com.tapjoy.TapjoyUtil;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TapjoyCacheMap
extends ConcurrentHashMap {
    private Context a;
    private int b = -1;

    public TapjoyCacheMap(Context applicationContext, int cacheLimit) {
        this.a = applicationContext;
        this.b = cacheLimit;
    }

    private String a() {
        long l2 = -1L;
        String string2 = "";
        for (Map.Entry entry : this.entrySet()) {
            long l3 = ((TapjoyCachedAssetData)entry.getValue()).getTimestampInSeconds();
            if (l2 != 0L && l3 >= l2) continue;
            l2 = l3;
            string2 = (String)entry.getKey();
        }
        return string2;
    }

    @Override
    public TapjoyCachedAssetData put(String key, TapjoyCachedAssetData assetData) {
        TapjoyLog.d("TapjoyCacheMap", "TapjoyCacheMap::put() -- key: " + key + " assetURL: " + assetData.getAssetURL());
        if (assetData == null) {
            return null;
        }
        if (assetData.getTimeOfDeathInSeconds() <= System.currentTimeMillis() / 1000L) {
            return null;
        }
        if (this.size() == this.b) {
            this.remove(this.a());
        }
        SharedPreferences.Editor editor = this.a.getSharedPreferences("tapjoyCacheData", 0).edit();
        editor.putString(assetData.getLocalFilePath(), assetData.toRawJSONString());
        editor.commit();
        return super.put(key, assetData);
    }

    @Override
    public TapjoyCachedAssetData remove(Object key) {
        if (this.containsKey(key)) {
            SharedPreferences.Editor editor = this.a.getSharedPreferences("tapjoyCacheData", 0).edit();
            editor.remove(((TapjoyCachedAssetData)this.get(key)).getLocalFilePath());
            editor.commit();
            String string2 = ((TapjoyCachedAssetData)this.get(key)).getLocalFilePath();
            if (string2 != null && string2.length() > 0) {
                TapjoyUtil.deleteFileOrDirectory(new File(string2));
            }
            TapjoyLog.d("TapjoyCacheMap", "TapjoyCacheMap::remove() -- key: " + key);
            return (TapjoyCachedAssetData)super.remove(key);
        }
        return null;
    }

    @Override
    public boolean replace(String key, TapjoyCachedAssetData oldValue, TapjoyCachedAssetData newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TapjoyCachedAssetData replace(String key, TapjoyCachedAssetData value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

