/*
 * Decompiled with CFR 0.152.
 */
package com.tapjoy;

import android.content.Context;
import android.content.SharedPreferences;
import com.tapjoy.TapjoyLog;
import com.tapjoy.internal.ct;

public class TapjoyAppSettings {
    public static final String TAG = TapjoyAppSettings.class.getSimpleName();
    private static TapjoyAppSettings b;
    private Context c;
    private SharedPreferences d;
    String a;

    private TapjoyAppSettings(Context applicationContext) {
        this.c = applicationContext;
        this.d = this.c.getSharedPreferences("tjcPrefrences", 0);
        TapjoyAppSettings tapjoyAppSettings = this;
        tapjoyAppSettings.a = tapjoyAppSettings.d.getString("tapjoyLogLevel", null);
        if (!ct.c(tapjoyAppSettings.a)) {
            TapjoyLog.d(TAG, "restoreLoggingLevel from sharedPref -- loggingLevel=" + tapjoyAppSettings.a);
            TapjoyLog.a(tapjoyAppSettings.a, true);
        }
    }

    public static TapjoyAppSettings getInstance() {
        return b;
    }

    public static void init(Context applicationContext) {
        TapjoyLog.d(TAG, "initializing app settings");
        b = new TapjoyAppSettings(applicationContext);
    }

    public void saveLoggingLevel(String level) {
        if (ct.c(level)) {
            TapjoyLog.d(TAG, "saveLoggingLevel -- server logging level is NULL or Empty string");
            return;
        }
        TapjoyLog.d(TAG, "saveLoggingLevel -- currentLevel=" + this.a + ";newLevel=" + level);
        if (ct.c(this.a) || !this.a.equals(level)) {
            SharedPreferences.Editor editor = this.d.edit();
            editor.putString("tapjoyLogLevel", level);
            editor.commit();
            this.a = level;
            TapjoyLog.a(this.a, true);
        }
        boolean bl2 = TapjoyLog.isLoggingEnabled();
        TapjoyLog.i(TAG, "Tapjoy remote device debugging set to '" + level + "'. The SDK Debug-setting is: " + (bl2 ? "'Enabled'" : "'Disabled'"));
    }

    public void clearLoggingLevel() {
        SharedPreferences.Editor editor = this.d.edit();
        editor.remove("tapjoyLogLevel");
        editor.commit();
        this.a = null;
        boolean bl2 = TapjoyLog.isLoggingEnabled();
        TapjoyLog.i(TAG, "Tapjoy remote device debugging 'Disabled'. The SDK Debug-setting is: " + (bl2 ? "'Enabled'" : "'Disabled'"));
        TapjoyLog.setDebugEnabled(bl2);
    }

    public void saveConnectResultAndParams(String result, String paramsHash, long expires) {
        if (ct.c(result) || ct.c(paramsHash)) {
            return;
        }
        SharedPreferences.Editor editor = this.d.edit();
        editor.putString("connectResult", result);
        editor.putString("connectParamsHash", paramsHash);
        if (expires >= 0L) {
            editor.putLong("connectResultExpires", expires);
        } else {
            editor.remove("connectResultExpires");
        }
        TapjoyLog.i(TAG, "Stored connect result");
        editor.commit();
    }

    public void removeConnectResult() {
        if (this.d.getString("connectParamsHash", null) != null) {
            SharedPreferences.Editor editor = this.d.edit();
            editor.remove("connectResult");
            editor.remove("connectParamsHash");
            editor.remove("connectResultExpires");
            TapjoyLog.i(TAG, "Removed connect result");
            editor.commit();
        }
    }

    public String getConnectResult(String paramsHash, long currentTimeMillis) {
        long l2;
        String string2 = this.d.getString("connectResult", null);
        if (ct.c(string2)) {
            return null;
        }
        if (!ct.c(paramsHash) && paramsHash.equals(this.d.getString("connectParamsHash", null)) && ((l2 = this.d.getLong("connectResultExpires", -1L)) < 0L || l2 >= currentTimeMillis)) {
            return string2;
        }
        return null;
    }
}

