/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text.util;

import com.taobao.text.util.BaseIterator;
import com.taobao.text.util.Pair;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CharSlicer {
    private final String value;
    private Pair<Integer, Integer> size;

    public CharSlicer(String value) {
        this.value = value;
        this.size = this.size();
    }

    public Pair<Integer, Integer> size() {
        if (this.size == null) {
            this.size = CharSlicer.size(this.value);
        }
        return this.size;
    }

    private static Pair<Integer, Integer> size(String s) {
        int height = 1;
        int maxWidth = 0;
        int lastLineBegin = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\n') continue;
            ++height;
            if (i - lastLineBegin > maxWidth) {
                maxWidth = i - lastLineBegin - 1;
            }
            lastLineBegin = i;
        }
        if (lastLineBegin < 0) {
            maxWidth = s.length();
        }
        return Pair.of(maxWidth, height);
    }

    public Pair<Integer, Integer>[] lines(int width) {
        return this.lines(this.linesIterator(width), 0);
    }

    private Pair<Integer, Integer>[] lines(Iterator<Pair<Integer, Integer>> i, int count) {
        Pair[] lines;
        if (i.hasNext()) {
            Pair<Integer, Integer> n = i.next();
            lines = this.lines(i, count + 1);
            lines[count] = n;
        } else {
            lines = new Pair[count];
        }
        return lines;
    }

    public Iterator<Pair<Integer, Integer>> linesIterator(final int width) {
        if (width < 1) {
            throw new IllegalArgumentException("A non positive width=" + width + " cannot be accepted");
        }
        return new BaseIterator<Pair<Integer, Integer>>(){
            int index = 0;
            Pair<Integer, Integer> next = null;

            @Override
            public boolean hasNext() {
                if (this.next == null && this.index != Integer.MAX_VALUE) {
                    int pos = CharSlicer.this.value.indexOf(10, this.index);
                    int nextIndex = pos == -1 ? (pos = Math.min(this.index + width, CharSlicer.this.value.length())) : (pos <= this.index + width ? pos + 1 : (pos = this.index + width));
                    this.next = Pair.of(this.index, pos);
                    this.index = pos < CharSlicer.this.value.length() ? nextIndex : Integer.MAX_VALUE;
                }
                return this.next != null;
            }

            @Override
            public Pair<Integer, Integer> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Pair<Integer, Integer> next = this.next;
                this.next = null;
                return next;
            }
        };
    }
}

