/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.attach;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import sun.tools.attach.HotSpotAttachProvider;
import sun.tools.attach.WindowsVirtualMachine;

public class WindowsAttachProvider
extends HotSpotAttachProvider {
    private static final long FS_PERSISTENT_ACLS = 8L;
    private static volatile boolean wasTempPathChecked;
    private static boolean isTempPathSecure;

    public WindowsAttachProvider() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows 9") || os.equals("Windows Me")) {
            throw new RuntimeException("This provider is not supported on this version of Windows");
        }
        String arch = System.getProperty("os.arch");
        if (!arch.equals("x86") && !arch.equals("amd64")) {
            throw new RuntimeException("This provider is not supported on this processor architecture");
        }
    }

    @Override
    public String name() {
        return "sun";
    }

    @Override
    public String type() {
        return "windows";
    }

    @Override
    public VirtualMachine attachVirtualMachine(String vmid) throws AttachNotSupportedException, IOException {
        this.checkAttachPermission();
        this.testAttachable(vmid);
        return new WindowsVirtualMachine(this, vmid);
    }

    @Override
    public List<VirtualMachineDescriptor> listVirtualMachines() {
        if (WindowsAttachProvider.isTempPathSecure()) {
            return super.listVirtualMachines();
        }
        return this.listJavaProcesses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isTempPathSecure() {
        if (wasTempPathChecked) return isTempPathSecure;
        Class<WindowsAttachProvider> clazz = WindowsAttachProvider.class;
        synchronized (WindowsAttachProvider.class) {
            if (wasTempPathChecked) return isTempPathSecure;
            String temp = WindowsAttachProvider.tempPath();
            if (temp != null && temp.length() >= 3 && temp.charAt(1) == ':' && temp.charAt(2) == '\\') {
                long flags = WindowsAttachProvider.volumeFlags(temp.substring(0, 3));
                isTempPathSecure = (flags & 8L) != 0L;
            }
            wasTempPathChecked = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return isTempPathSecure;
        }
    }

    private static native String tempPath();

    private static native long volumeFlags(String var0);

    private List<VirtualMachineDescriptor> listJavaProcesses() {
        ArrayList<VirtualMachineDescriptor> list = new ArrayList<VirtualMachineDescriptor>();
        String host = "localhost";
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        int[] processes = new int[1024];
        int count = WindowsAttachProvider.enumProcesses(processes, processes.length);
        for (int i = 0; i < count; ++i) {
            if (!WindowsAttachProvider.isLibraryLoadedByProcess("jvm.dll", processes[i])) continue;
            String pid = Integer.toString(processes[i]);
            try {
                new WindowsVirtualMachine(this, pid).detach();
                String name = pid + "@" + host;
                list.add(new HotSpotAttachProvider.HotSpotVirtualMachineDescriptor(this, pid, name));
                continue;
            }
            catch (AttachNotSupportedException attachNotSupportedException) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return list;
    }

    private static native int enumProcesses(int[] var0, int var1);

    private static native boolean isLibraryLoadedByProcess(String var0, int var1);

    static {
        System.loadLibrary("attach");
    }
}

