/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.protocol.local;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.VmIdentifier;
import sun.jvmstat.monitor.event.HostListener;
import sun.jvmstat.monitor.event.VmStatusChangeEvent;
import sun.jvmstat.perfdata.monitor.CountedTimerTask;
import sun.jvmstat.perfdata.monitor.CountedTimerTaskUtils;
import sun.jvmstat.perfdata.monitor.protocol.local.LocalEventTimer;
import sun.jvmstat.perfdata.monitor.protocol.local.LocalMonitoredVm;
import sun.jvmstat.perfdata.monitor.protocol.local.LocalVmManager;

public class MonitoredHostProvider
extends MonitoredHost {
    private static final int DEFAULT_POLLING_INTERVAL = 1000;
    private ArrayList<HostListener> listeners;
    private NotifierTask task;
    private HashSet<Integer> activeVms;
    private LocalVmManager vmManager;

    public MonitoredHostProvider(HostIdentifier hostId) {
        this.hostId = hostId;
        this.listeners = new ArrayList();
        this.interval = 1000;
        this.activeVms = new HashSet();
        this.vmManager = new LocalVmManager();
    }

    @Override
    public MonitoredVm getMonitoredVm(VmIdentifier vmid) throws MonitorException {
        return this.getMonitoredVm(vmid, 1000);
    }

    @Override
    public MonitoredVm getMonitoredVm(VmIdentifier vmid, int interval) throws MonitorException {
        try {
            VmIdentifier nvmid = this.hostId.resolve(vmid);
            return new LocalMonitoredVm(nvmid, interval);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Malformed URI: " + vmid.toString(), e);
        }
    }

    @Override
    public void detach(MonitoredVm vm) {
        vm.detach();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHostListener(HostListener listener) {
        ArrayList<HostListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
            if (this.task == null) {
                this.task = new NotifierTask();
                LocalEventTimer timer = LocalEventTimer.getInstance();
                timer.schedule((TimerTask)this.task, this.interval, (long)this.interval);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHostListener(HostListener listener) {
        ArrayList<HostListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty() && this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInterval(int newInterval) {
        ArrayList<HostListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (newInterval == this.interval) {
                return;
            }
            int oldInterval = this.interval;
            super.setInterval(newInterval);
            if (this.task != null) {
                this.task.cancel();
                NotifierTask oldTask = this.task;
                this.task = new NotifierTask();
                LocalEventTimer timer = LocalEventTimer.getInstance();
                CountedTimerTaskUtils.reschedule(timer, oldTask, this.task, oldInterval, newInterval);
            }
        }
    }

    @Override
    public Set<Integer> activeVms() {
        return this.vmManager.activeVms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVmStatusChangedEvents(Set active, Set started, Set terminated) {
        ArrayList registered = null;
        VmStatusChangeEvent ev = null;
        ArrayList<HostListener> arrayList = this.listeners;
        synchronized (arrayList) {
            registered = (ArrayList)this.listeners.clone();
        }
        for (HostListener l : registered) {
            if (ev == null) {
                ev = new VmStatusChangeEvent(this, active, started, terminated);
            }
            l.vmStatusChanged(ev);
        }
    }

    private class NotifierTask
    extends CountedTimerTask {
        private NotifierTask() {
        }

        @Override
        public void run() {
            super.run();
            HashSet lastActiveVms = MonitoredHostProvider.this.activeVms;
            MonitoredHostProvider.this.activeVms = (HashSet)MonitoredHostProvider.this.vmManager.activeVms();
            if (MonitoredHostProvider.this.activeVms.isEmpty()) {
                return;
            }
            HashSet<Integer> startedVms = new HashSet<Integer>();
            HashSet terminatedVms = new HashSet();
            for (Integer vmid : MonitoredHostProvider.this.activeVms) {
                if (lastActiveVms.contains(vmid)) continue;
                startedVms.add(vmid);
            }
            for (Object o : lastActiveVms) {
                if (MonitoredHostProvider.this.activeVms.contains(o)) continue;
                terminatedVms.add(o);
            }
            if (!startedVms.isEmpty() || !terminatedVms.isEmpty()) {
                MonitoredHostProvider.this.fireVmStatusChangedEvents(MonitoredHostProvider.this.activeVms, startedVms, terminatedVms);
            }
        }
    }
}

