/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text.renderers;

import com.taobao.text.Color;
import com.taobao.text.LineRenderer;
import com.taobao.text.Renderer;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.util.BaseIterator;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class LogRecordRenderer
extends Renderer<LogRecord> {
    @Override
    public Class<LogRecord> getType() {
        return LogRecord.class;
    }

    @Override
    public LineRenderer renderer(final Iterator<LogRecord> stream) {
        return LineRenderer.vertical((Iterable<? extends LineRenderer>)new Iterable<LineRenderer>(){

            @Override
            public Iterator<LineRenderer> iterator() {
                return new BaseIterator<LineRenderer>(){
                    final SimpleFormatter formatter = new SimpleFormatter();

                    @Override
                    public boolean hasNext() {
                        return stream.hasNext();
                    }

                    @Override
                    public LineRenderer next() {
                        LogRecord record = (LogRecord)stream.next();
                        String line = this.formatter.format(record);
                        Color color = record.getLevel() == Level.SEVERE ? Color.red : (record.getLevel() == Level.WARNING ? Color.yellow : (record.getLevel() == Level.INFO ? Color.green : Color.blue));
                        return new LabelElement(line).style(color.fg()).renderer();
                    }
                };
            }
        });
    }
}

