/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import com.taobao.arthas.core.util.ArthasBanner;
import com.taobao.arthas.core.util.IPUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class UserStatUtil {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final byte[] SKIP_BYTE_BUFFER = new byte[8192];
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "arthas-UserStat");
            t.setDaemon(true);
            return t;
        }
    });
    private static final String ip = IPUtils.getLocalIP();
    private static final String version = URLEncoder.encode(ArthasBanner.version().replace("\n", ""));
    private static volatile String statUrl = null;
    private static volatile String agentId = null;

    public static String getStatUrl() {
        return statUrl;
    }

    public static void setStatUrl(String url) {
        statUrl = url;
    }

    public static String getAgentId() {
        return agentId;
    }

    public static void setAgentId(String id) {
        agentId = id;
    }

    public static void arthasStart() {
        if (statUrl == null) {
            return;
        }
        RemoteJob job = new RemoteJob();
        job.appendQueryData("ip", ip);
        job.appendQueryData("version", version);
        if (agentId != null) {
            job.appendQueryData("agentId", agentId);
        }
        job.appendQueryData("command", "start");
        try {
            executorService.execute(job);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void arthasUsage(String cmd, String detail, String userId) {
        RemoteJob job = new RemoteJob();
        job.appendQueryData("ip", ip);
        job.appendQueryData("version", version);
        if (agentId != null) {
            job.appendQueryData("agentId", agentId);
        }
        if (userId != null) {
            job.appendQueryData("userId", URLEncoder.encode(userId));
        }
        job.appendQueryData("command", URLEncoder.encode(cmd));
        if (detail != null) {
            job.appendQueryData("arguments", URLEncoder.encode(detail));
        }
        try {
            executorService.execute(job);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void arthasUsageSuccess(String cmd, List<String> args2, String userId) {
        if (statUrl == null) {
            return;
        }
        StringBuilder commandString = new StringBuilder(cmd);
        for (String arg : args2) {
            commandString.append(" ").append(arg);
        }
        UserStatUtil.arthasUsage(cmd, commandString.toString(), userId);
    }

    public static void arthasUsageSuccess(String cmd, List<String> args2) {
        UserStatUtil.arthasUsageSuccess(cmd, args2, null);
    }

    public static void destroy() {
        executorService.shutdownNow();
    }

    static class RemoteJob
    implements Runnable {
        private StringBuilder queryData = new StringBuilder();

        RemoteJob() {
        }

        public void appendQueryData(String key, String value) {
            if (key != null && value != null) {
                if (this.queryData.length() == 0) {
                    this.queryData.append(key).append("=").append(value);
                } else {
                    this.queryData.append("&").append(key).append("=").append(value);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String link = statUrl;
            if (link == null) {
                return;
            }
            InputStream inputStream2 = null;
            try {
                if (this.queryData.length() != 0) {
                    link = link + "?" + this.queryData;
                }
                URL url = new URL(link);
                URLConnection connection = url.openConnection();
                connection.setConnectTimeout(1000);
                connection.setReadTimeout(1000);
                connection.connect();
                inputStream2 = connection.getInputStream();
                while (inputStream2.read(SKIP_BYTE_BUFFER) != -1) {
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

