/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.command.impl;

import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.Command;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.util.UserStatUtil;
import com.taobao.middleware.cli.CLI;
import com.taobao.middleware.cli.Option;
import com.taobao.middleware.cli.annotations.CLIConfigurator;
import java.util.Collections;

public class AnnotatedCommandImpl
extends Command {
    private CLI cli;
    private Class<? extends AnnotatedCommand> clazz;
    private Handler<CommandProcess> processHandler = new ProcessHandler();

    public AnnotatedCommandImpl(Class<? extends AnnotatedCommand> clazz) {
        this.clazz = clazz;
        this.cli = CLIConfigurator.define(clazz, true);
        this.cli.addOption(new Option().setArgName("help").setFlag(true).setShortName("h").setLongName("help").setDescription("this help").setHelp(true));
    }

    private boolean shouldOverridesName(Class<? extends AnnotatedCommand> clazz) {
        try {
            clazz.getDeclaredMethod("name", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException ignore) {
            return false;
        }
    }

    private boolean shouldOverrideCli(Class<? extends AnnotatedCommand> clazz) {
        try {
            clazz.getDeclaredMethod("cli", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException ignore) {
            return false;
        }
    }

    @Override
    public String name() {
        if (this.shouldOverridesName(this.clazz)) {
            try {
                return this.clazz.newInstance().name();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.cli.getName();
    }

    @Override
    public CLI cli() {
        if (this.shouldOverrideCli(this.clazz)) {
            try {
                return this.clazz.newInstance().cli();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.cli;
    }

    private void process(CommandProcess process) {
        AnnotatedCommand instance;
        try {
            instance = this.clazz.newInstance();
        }
        catch (Exception e) {
            process.end();
            return;
        }
        CLIConfigurator.inject(process.commandLine(), instance);
        instance.process(process);
        String userId = process.session() != null ? process.session().getUserId() : null;
        UserStatUtil.arthasUsageSuccess(this.name(), process.args(), userId);
    }

    @Override
    public Handler<CommandProcess> processHandler() {
        return this.processHandler;
    }

    @Override
    public void complete(Completion completion) {
        AnnotatedCommand instance;
        try {
            instance = this.clazz.newInstance();
        }
        catch (Exception e) {
            super.complete(completion);
            return;
        }
        try {
            instance.complete(completion);
        }
        catch (Throwable t) {
            completion.complete(Collections.emptyList());
        }
    }

    private class ProcessHandler
    implements Handler<CommandProcess> {
        private ProcessHandler() {
        }

        @Override
        public void handle(CommandProcess process) {
            AnnotatedCommandImpl.this.process(process);
        }
    }
}

