/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.v1_0;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Map;
import sun.jvmstat.monitor.AbstractMonitor;
import sun.jvmstat.monitor.IntegerMonitor;
import sun.jvmstat.monitor.LongMonitor;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.StringMonitor;
import sun.jvmstat.monitor.Units;
import sun.jvmstat.monitor.Variability;
import sun.jvmstat.perfdata.monitor.MonitorDataException;
import sun.jvmstat.perfdata.monitor.MonitorStatus;
import sun.jvmstat.perfdata.monitor.MonitorStructureException;
import sun.jvmstat.perfdata.monitor.MonitorTypeException;
import sun.jvmstat.perfdata.monitor.PerfDataBufferImpl;
import sun.jvmstat.perfdata.monitor.PerfIntegerMonitor;
import sun.jvmstat.perfdata.monitor.PerfLongMonitor;
import sun.jvmstat.perfdata.monitor.PerfStringConstantMonitor;
import sun.jvmstat.perfdata.monitor.PerfStringVariableMonitor;
import sun.jvmstat.perfdata.monitor.v1_0.BasicType;
import sun.jvmstat.perfdata.monitor.v1_0.PerfDataBufferPrologue;

public class PerfDataBuffer
extends PerfDataBufferImpl {
    private static final boolean DEBUG = false;
    private static final int syncWaitMs = Integer.getInteger("sun.jvmstat.perdata.syncWaitMs", 5000);
    private static final ArrayList EMPTY_LIST = new ArrayList(0);
    private static final int PERFDATA_ENTRYLENGTH_OFFSET = 0;
    private static final int PERFDATA_ENTRYLENGTH_SIZE = 4;
    private static final int PERFDATA_NAMELENGTH_OFFSET = 4;
    private static final int PERFDATA_NAMELENGTH_SIZE = 4;
    private static final int PERFDATA_VECTORLENGTH_OFFSET = 8;
    private static final int PERFDATA_VECTORLENGTH_SIZE = 4;
    private static final int PERFDATA_DATATYPE_OFFSET = 12;
    private static final int PERFDATA_DATATYPE_SIZE = 1;
    private static final int PERFDATA_FLAGS_OFFSET = 13;
    private static final int PERFDATA_FLAGS_SIZE = 1;
    private static final int PERFDATA_DATAUNITS_OFFSET = 14;
    private static final int PERFDATA_DATAUNITS_SIZE = 1;
    private static final int PERFDATA_DATAATTR_OFFSET = 15;
    private static final int PERFDATA_DATAATTR_SIZE = 1;
    private static final int PERFDATA_NAME_OFFSET = 16;
    PerfDataBufferPrologue prologue;
    int nextEntry;
    int pollForEntry;
    int perfDataItem;
    long lastModificationTime;
    int lastUsed;
    IntegerMonitor overflow;
    ArrayList<Monitor> insertedMonitors;

    public PerfDataBuffer(ByteBuffer buffer, int lvmid) throws MonitorException {
        super(buffer, lvmid);
        this.prologue = new PerfDataBufferPrologue(buffer);
        this.buffer.order(this.prologue.getByteOrder());
    }

    @Override
    protected void buildMonitorMap(Map<String, Monitor> map) throws MonitorException {
        assert (Thread.holdsLock(this));
        this.buffer.rewind();
        this.buildPseudoMonitors(map);
        this.buffer.position(this.prologue.getSize());
        this.nextEntry = this.buffer.position();
        this.perfDataItem = 0;
        int used = this.prologue.getUsed();
        long modificationTime = this.prologue.getModificationTimeStamp();
        Monitor m3 = this.getNextMonitorEntry();
        while (m3 != null) {
            map.put(m3.getName(), m3);
            m3 = this.getNextMonitorEntry();
        }
        this.lastUsed = used;
        this.lastModificationTime = modificationTime;
        this.synchWithTarget(map);
        this.kludge(map);
        this.insertedMonitors = new ArrayList<Monitor>(map.values());
    }

    @Override
    protected void getNewMonitors(Map<String, Monitor> map) throws MonitorException {
        assert (Thread.holdsLock(this));
        int used = this.prologue.getUsed();
        long modificationTime = this.prologue.getModificationTimeStamp();
        if (used > this.lastUsed || this.lastModificationTime > modificationTime) {
            this.lastUsed = used;
            this.lastModificationTime = modificationTime;
            Monitor monitor = this.getNextMonitorEntry();
            while (monitor != null) {
                String name = monitor.getName();
                if (!map.containsKey(name)) {
                    map.put(name, monitor);
                    if (this.insertedMonitors != null) {
                        this.insertedMonitors.add(monitor);
                    }
                }
                monitor = this.getNextMonitorEntry();
            }
        }
    }

    @Override
    protected MonitorStatus getMonitorStatus(Map<String, Monitor> map) throws MonitorException {
        assert (Thread.holdsLock(this));
        assert (this.insertedMonitors != null);
        this.getNewMonitors(map);
        ArrayList removed = EMPTY_LIST;
        ArrayList<Monitor> inserted = this.insertedMonitors;
        this.insertedMonitors = new ArrayList();
        return new MonitorStatus(inserted, removed);
    }

    protected void buildPseudoMonitors(Map<String, Monitor> map) {
        AbstractMonitor monitor = null;
        String name = null;
        IntBuffer ib = null;
        name = "sun.perfdata.majorVersion";
        ib = this.prologue.majorVersionBuffer();
        monitor = new PerfIntegerMonitor(name, Units.NONE, Variability.CONSTANT, false, ib);
        map.put(name, monitor);
        name = "sun.perfdata.minorVersion";
        ib = this.prologue.minorVersionBuffer();
        monitor = new PerfIntegerMonitor(name, Units.NONE, Variability.CONSTANT, false, ib);
        map.put(name, monitor);
        name = "sun.perfdata.size";
        ib = this.prologue.sizeBuffer();
        monitor = new PerfIntegerMonitor(name, Units.BYTES, Variability.MONOTONIC, false, ib);
        map.put(name, monitor);
        name = "sun.perfdata.used";
        ib = this.prologue.usedBuffer();
        monitor = new PerfIntegerMonitor(name, Units.BYTES, Variability.MONOTONIC, false, ib);
        map.put(name, monitor);
        name = "sun.perfdata.overflow";
        ib = this.prologue.overflowBuffer();
        monitor = new PerfIntegerMonitor(name, Units.BYTES, Variability.MONOTONIC, false, ib);
        map.put(name, monitor);
        this.overflow = monitor;
        name = "sun.perfdata.timestamp";
        LongBuffer lb = this.prologue.modificationTimeStampBuffer();
        monitor = new PerfLongMonitor(name, Units.TICKS, Variability.MONOTONIC, false, lb);
        map.put(name, monitor);
    }

    protected void synchWithTarget(Map<String, Monitor> map) throws MonitorException {
        long timeLimit = System.currentTimeMillis() + (long)syncWaitMs;
        String name = "hotspot.rt.hrt.ticks";
        LongMonitor ticks = (LongMonitor)this.pollFor(map, name, timeLimit);
        this.log("synchWithTarget: " + this.lvmid + " ");
        while (ticks.longValue() == 0L) {
            this.log(".");
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= timeLimit) continue;
            this.lognl("failed: " + this.lvmid);
            throw new MonitorException("Could Not Synchronize with target");
        }
        this.lognl("success: " + this.lvmid);
    }

    protected Monitor pollFor(Map<String, Monitor> map, String name, long timeLimit) throws MonitorException {
        Monitor monitor = null;
        this.log("polling for: " + this.lvmid + "," + name + " ");
        this.pollForEntry = this.nextEntry;
        while ((monitor = map.get(name)) == null) {
            this.log(".");
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long t = System.currentTimeMillis();
            if (t > timeLimit || this.overflow.intValue() > 0) {
                this.lognl("failed: " + this.lvmid + "," + name);
                this.dumpAll(map, this.lvmid);
                throw new MonitorException("Could not find expected counter");
            }
            this.getNewMonitors(map);
        }
        this.lognl("success: " + this.lvmid + "," + name);
        return monitor;
    }

    protected void kludge(Map<String, Monitor> map) {
        StringMonitor args2;
        StringMonitor jvm_name;
        if (Boolean.getBoolean("sun.jvmstat.perfdata.disableKludge")) {
            return;
        }
        String name = "java.vm.version";
        StringMonitor jvm_version = (StringMonitor)map.get(name);
        if (jvm_version == null) {
            jvm_version = (StringMonitor)this.findByAlias(name);
        }
        if ((jvm_name = (StringMonitor)map.get(name = "java.vm.name")) == null) {
            jvm_name = (StringMonitor)this.findByAlias(name);
        }
        if ((args2 = (StringMonitor)map.get(name = "hotspot.vm.args")) == null) {
            args2 = (StringMonitor)this.findByAlias(name);
        }
        assert (jvm_name != null && jvm_version != null && args2 != null);
        if (jvm_name.stringValue().indexOf("HotSpot") >= 0 && jvm_version.stringValue().startsWith("1.4.2")) {
            this.kludgeMantis(map, args2);
        }
    }

    private void kludgeMantis(Map<String, Monitor> map, StringMonitor args2) {
        String cname = "hotspot.gc.collector.0.name";
        StringMonitor collector = (StringMonitor)map.get(cname);
        if (collector.stringValue().compareTo("PSScavenge") == 0) {
            boolean adaptiveSizePolicy = true;
            cname = "hotspot.vm.flags";
            StringMonitor flags = (StringMonitor)map.get(cname);
            String allArgs = flags.stringValue() + " " + args2.stringValue();
            int ahi = allArgs.lastIndexOf("+AggressiveHeap");
            int aspi = allArgs.lastIndexOf("-UseAdaptiveSizePolicy");
            if (ahi != -1) {
                if (aspi != -1 && aspi > ahi) {
                    adaptiveSizePolicy = false;
                }
            } else if (aspi != -1) {
                adaptiveSizePolicy = false;
            }
            if (adaptiveSizePolicy) {
                String eden_size = "hotspot.gc.generation.0.space.0.size";
                String s0_size = "hotspot.gc.generation.0.space.1.size";
                String s1_size = "hotspot.gc.generation.0.space.2.size";
                map.remove(eden_size);
                map.remove(s0_size);
                map.remove(s1_size);
                String new_max_name = "hotspot.gc.generation.0.capacity.max";
                LongMonitor new_max = (LongMonitor)map.get(new_max_name);
                PerfLongMonitor monitor = null;
                LongBuffer lb = LongBuffer.allocate(1);
                lb.put(new_max.longValue());
                monitor = new PerfLongMonitor(eden_size, Units.BYTES, Variability.CONSTANT, false, lb);
                map.put(eden_size, monitor);
                monitor = new PerfLongMonitor(s0_size, Units.BYTES, Variability.CONSTANT, false, lb);
                map.put(s0_size, monitor);
                monitor = new PerfLongMonitor(s1_size, Units.BYTES, Variability.CONSTANT, false, lb);
                map.put(s1_size, monitor);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Monitor getNextMonitorEntry() throws MonitorException {
        void var1_6;
        boolean supported;
        Object var1_1 = null;
        if (this.nextEntry % 4 != 0) {
            throw new MonitorStructureException("Entry index not properly aligned: " + this.nextEntry);
        }
        if (this.nextEntry < 0 || this.nextEntry > this.buffer.limit()) {
            throw new MonitorStructureException("Entry index out of bounds: nextEntry = " + this.nextEntry + ", limit = " + this.buffer.limit());
        }
        if (this.nextEntry == this.buffer.limit()) {
            this.lognl("getNextMonitorEntry(): nextEntry == buffer.limit(): returning");
            return null;
        }
        this.buffer.position(this.nextEntry);
        int entryStart = this.buffer.position();
        int entryLength = this.buffer.getInt();
        if (entryLength < 0 || entryLength > this.buffer.limit()) {
            throw new MonitorStructureException("Invalid entry length: entryLength = " + entryLength);
        }
        if (entryStart + entryLength > this.buffer.limit()) {
            throw new MonitorStructureException("Entry extends beyond end of buffer:  entryStart = " + entryStart + " entryLength = " + entryLength + " buffer limit = " + this.buffer.limit());
        }
        if (entryLength == 0) {
            return null;
        }
        int nameLength = this.buffer.getInt();
        int vectorLength = this.buffer.getInt();
        byte dataType = this.buffer.get();
        byte flags = this.buffer.get();
        Units u = Units.toUnits(this.buffer.get());
        Variability v = Variability.toVariability(this.buffer.get());
        boolean bl = supported = (flags & 1) != 0;
        if (nameLength <= 0 || nameLength > entryLength) {
            throw new MonitorStructureException("Invalid Monitor name length: " + nameLength);
        }
        if (vectorLength < 0 || vectorLength > entryLength) {
            throw new MonitorStructureException("Invalid Monitor vector length: " + vectorLength);
        }
        byte[] nameBytes = new byte[nameLength - 1];
        for (int i = 0; i < nameLength - 1; ++i) {
            nameBytes[i] = this.buffer.get();
        }
        String name = new String(nameBytes, 0, nameLength - 1);
        if (v == Variability.INVALID) {
            throw new MonitorDataException("Invalid variability attribute: entry index = " + this.perfDataItem + " name = " + name);
        }
        if (u == Units.INVALID) {
            throw new MonitorDataException("Invalid units attribute:  entry index = " + this.perfDataItem + " name = " + name);
        }
        if (vectorLength == 0) {
            if (dataType != BasicType.LONG.intValue()) throw new MonitorTypeException("Invalid Monitor type: entry index = " + this.perfDataItem + " name = " + name + " type = " + dataType);
            int offset = entryStart + entryLength - 8;
            this.buffer.position(offset);
            LongBuffer lb = this.buffer.asLongBuffer();
            lb.limit(1);
            PerfLongMonitor perfLongMonitor = new PerfLongMonitor(name, u, v, supported, lb);
            ++this.perfDataItem;
        } else {
            if (dataType != BasicType.BYTE.intValue()) throw new MonitorTypeException("Invalid Monitor type: entry index = " + this.perfDataItem + " name = " + name + " type = " + dataType);
            if (u != Units.STRING) {
                throw new MonitorTypeException("Invalid Monitor type: entry index = " + this.perfDataItem + " name = " + name + " type = " + dataType);
            }
            int offset = entryStart + 16 + nameLength;
            this.buffer.position(offset);
            ByteBuffer bb = this.buffer.slice();
            bb.limit(vectorLength);
            bb.position(0);
            if (v == Variability.CONSTANT) {
                PerfStringConstantMonitor perfStringConstantMonitor = new PerfStringConstantMonitor(name, supported, bb);
            } else {
                if (v != Variability.VARIABLE) throw new MonitorDataException("Invalid variability attribute: entry index = " + this.perfDataItem + " name = " + name + " variability = " + v);
                PerfStringVariableMonitor perfStringVariableMonitor = new PerfStringVariableMonitor(name, supported, bb, vectorLength - 1);
            }
            ++this.perfDataItem;
        }
        this.nextEntry = entryStart + entryLength;
        return var1_6;
    }

    private void dumpAll(Map map, int lvmid) {
    }

    private void lognl(String s2) {
    }

    private void log(String s2) {
    }
}

