/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.loc;

import java.util.Map;
import java.util.Set;
import org.benf.cfr.reader.bytecode.analysis.loc.BytecodeLoc;
import org.benf.cfr.reader.bytecode.analysis.loc.BytecodeLocSet;
import org.benf.cfr.reader.bytecode.analysis.loc.BytecodeLocSimple;
import org.benf.cfr.reader.entities.Method;
import org.benf.cfr.reader.util.collections.CollectionUtils;
import org.benf.cfr.reader.util.collections.MapFactory;
import org.benf.cfr.reader.util.collections.SetFactory;
import org.benf.cfr.reader.util.collections.SetUtil;

public class BytecodeLocCollector {
    private final Map<Method, Set<Integer>> data = MapFactory.newIdentityMap();

    private Set<Integer> getForMethod(Method method) {
        Set<Integer> locs = this.data.get(method);
        if (locs == null) {
            locs = SetFactory.newSet();
            this.data.put(method, locs);
        }
        return locs;
    }

    public void add(Method method, int offset) {
        this.getForMethod(method).add(offset);
    }

    public void add(Method method, Set<Integer> offsets) {
        this.getForMethod(method).addAll(offsets);
    }

    public BytecodeLoc getLoc() {
        Set<Integer> s2;
        if (this.data.isEmpty()) {
            return BytecodeLoc.NONE;
        }
        if (this.data.values().size() == 1 && (s2 = CollectionUtils.getSingle(this.data.values())).size() == 1) {
            return new BytecodeLocSimple(SetUtil.getSingle(s2), SetUtil.getSingle(this.data.keySet()));
        }
        return new BytecodeLocSet(this.data);
    }
}

