/*
 * Decompiled with CFR 0.152.
 */
package one.profiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import one.profiler.AsyncProfilerMXBean;
import one.profiler.Counter;

public class AsyncProfiler
implements AsyncProfilerMXBean {
    private static AsyncProfiler instance;

    private AsyncProfiler() {
    }

    public static AsyncProfiler getInstance() {
        return AsyncProfiler.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized AsyncProfiler getInstance(String libPath) {
        if (instance != null) {
            return instance;
        }
        AsyncProfiler profiler = new AsyncProfiler();
        if (libPath != null) {
            System.load(libPath);
        } else {
            try {
                profiler.getVersion();
            }
            catch (UnsatisfiedLinkError e) {
                File file = AsyncProfiler.extractEmbeddedLib();
                if (file != null) {
                    try {
                        System.load(file.getPath());
                    }
                    finally {
                        file.delete();
                    }
                }
                System.loadLibrary("asyncProfiler");
            }
        }
        instance = profiler;
        return profiler;
    }

    private static File extractEmbeddedLib() {
        String resourceName = "/" + AsyncProfiler.getPlatformTag() + "/libasyncProfiler.so";
        InputStream in = AsyncProfiler.class.getResourceAsStream(resourceName);
        if (in == null) {
            return null;
        }
        try {
            String extractPath = System.getProperty("one.profiler.extractPath");
            File file = File.createTempFile("libasyncProfiler-", ".so", extractPath == null || extractPath.isEmpty() ? null : new File(extractPath));
            try (FileOutputStream out = new FileOutputStream(file);){
                int bytes;
                byte[] buf = new byte[32000];
                while ((bytes = in.read(buf)) >= 0) {
                    out.write(buf, 0, bytes);
                }
            }
            File file2 = file;
            return file2;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static String getPlatformTag() {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        if (os.contains("linux")) {
            if (arch.equals("amd64") || arch.equals("x86_64") || arch.contains("x64")) {
                return "linux-x64";
            }
            if (arch.equals("aarch64") || arch.contains("arm64")) {
                return "linux-arm64";
            }
            if (arch.equals("aarch32") || arch.contains("arm")) {
                return "linux-arm32";
            }
            if (arch.contains("86")) {
                return "linux-x86";
            }
            if (arch.contains("ppc64")) {
                return "linux-ppc64le";
            }
        } else if (os.contains("mac")) {
            return "macos";
        }
        throw new UnsupportedOperationException("Unsupported platform: " + os + "-" + arch);
    }

    @Override
    public void start(String event, long interval) throws IllegalStateException {
        if (event == null) {
            throw new NullPointerException();
        }
        this.start0(event, interval, true);
    }

    @Override
    public void resume(String event, long interval) throws IllegalStateException {
        if (event == null) {
            throw new NullPointerException();
        }
        this.start0(event, interval, false);
    }

    @Override
    public void stop() throws IllegalStateException {
        this.stop0();
    }

    @Override
    public native long getSamples();

    @Override
    public String getVersion() {
        try {
            return this.execute0("version");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String execute(String command) throws IllegalArgumentException, IllegalStateException, IOException {
        if (command == null) {
            throw new NullPointerException();
        }
        return this.execute0(command);
    }

    @Override
    public String dumpCollapsed(Counter counter) {
        try {
            return this.execute0("collapsed," + counter.name().toLowerCase());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String dumpTraces(int maxTraces) {
        try {
            return this.execute0(maxTraces == 0 ? "traces" : "traces=" + maxTraces);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String dumpFlat(int maxMethods) {
        try {
            return this.execute0(maxMethods == 0 ? "flat" : "flat=" + maxMethods);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public byte[] dumpOtlp() {
        try {
            return this.execute1("otlp");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void addThread(Thread thread2) {
        this.filterThread(thread2, true);
    }

    public void removeThread(Thread thread2) {
        this.filterThread(thread2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterThread(Thread thread2, boolean enable) {
        if (thread2 == null || thread2 == Thread.currentThread()) {
            this.filterThread0(null, enable);
        } else {
            Thread thread3 = thread2;
            synchronized (thread3) {
                Thread.State state = thread2.getState();
                if (state != Thread.State.NEW && state != Thread.State.TERMINATED) {
                    this.filterThread0(thread2, enable);
                }
            }
        }
    }

    private native void start0(String var1, long var2, boolean var4) throws IllegalStateException;

    private native void stop0() throws IllegalStateException;

    private native String execute0(String var1) throws IllegalArgumentException, IllegalStateException, IOException;

    private native byte[] execute1(String var1) throws IllegalArgumentException, IllegalStateException, IOException;

    private native void filterThread0(Thread var1, boolean var2);
}

