/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.telnet;

import io.termd.core.function.BiConsumer;
import io.termd.core.function.Consumer;
import io.termd.core.io.BinaryDecoder;
import io.termd.core.io.BinaryEncoder;
import io.termd.core.io.TelnetCharset;
import io.termd.core.telnet.Option;
import io.termd.core.telnet.TelnetConnection;
import io.termd.core.telnet.TelnetHandler;
import io.termd.core.tty.ReadBuffer;
import io.termd.core.tty.TtyConnection;
import io.termd.core.tty.TtyEvent;
import io.termd.core.tty.TtyEventDecoder;
import io.termd.core.tty.TtyOutputMode;
import io.termd.core.util.Helper;
import io.termd.core.util.Vector;
import java.nio.charset.Charset;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public final class TelnetTtyConnection
extends TelnetHandler
implements TtyConnection {
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private final boolean inBinary;
    private final boolean outBinary;
    private boolean receivingBinary;
    private boolean sendingBinary;
    private boolean accepted;
    private Vector size;
    private String terminalType;
    private Consumer<Vector> sizeHandler;
    private Consumer<String> termHandler;
    private Consumer<Void> closeHandler;
    protected TelnetConnection conn;
    private final Charset charset;
    private final TtyEventDecoder eventDecoder = new TtyEventDecoder(3, 26, 4);
    private final ReadBuffer readBuffer = new ReadBuffer(new Executor(){

        @Override
        public void execute(Runnable command) {
            TelnetTtyConnection.this.execute(command);
        }
    });
    private final BinaryDecoder decoder;
    private final BinaryEncoder encoder;
    private final Consumer<int[]> stdout;
    private final Consumer<TtyConnection> handler;
    private long lastAccessedTime = System.currentTimeMillis();

    public TelnetTtyConnection(boolean inBinary, boolean outBinary, Charset charset, Consumer<TtyConnection> handler) {
        this.charset = charset;
        this.inBinary = inBinary;
        this.outBinary = outBinary;
        this.handler = handler;
        this.size = new Vector();
        this.decoder = new BinaryDecoder(512, TelnetCharset.INSTANCE, this.readBuffer);
        this.encoder = new BinaryEncoder(charset, new Consumer<byte[]>(){

            @Override
            public void accept(byte[] data) {
                TelnetTtyConnection.this.conn.write(data);
            }
        });
        this.stdout = new TtyOutputMode(this.encoder);
    }

    @Override
    public long lastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    public String terminalType() {
        return this.terminalType;
    }

    @Override
    public void execute(Runnable task) {
        this.conn.execute(task);
    }

    @Override
    public void schedule(Runnable task, long delay, TimeUnit unit) {
        this.conn.schedule(task, delay, unit);
    }

    @Override
    public Charset inputCharset() {
        return this.inBinary ? this.charset : US_ASCII;
    }

    @Override
    public Charset outputCharset() {
        return this.outBinary ? this.charset : US_ASCII;
    }

    @Override
    protected void onSendBinary(boolean binary) {
        this.sendingBinary = binary;
        if (binary) {
            this.encoder.setCharset(this.charset);
        }
        this.checkAccept();
    }

    @Override
    protected void onReceiveBinary(boolean binary) {
        this.receivingBinary = binary;
        if (binary) {
            this.decoder.setCharset(this.charset);
        }
        this.checkAccept();
    }

    @Override
    protected void onData(byte[] data) {
        this.lastAccessedTime = System.currentTimeMillis();
        this.decoder.write(data);
    }

    @Override
    protected void onOpen(TelnetConnection conn) {
        this.conn = conn;
        conn.writeWillOption(Option.ECHO);
        conn.writeWillOption(Option.SGA);
        if (this.inBinary) {
            conn.writeDoOption(Option.BINARY);
        }
        if (this.outBinary) {
            conn.writeWillOption(Option.BINARY);
        }
        conn.writeDoOption(Option.NAWS);
        conn.writeDoOption(Option.TERMINAL_TYPE);
        this.checkAccept();
    }

    private void checkAccept() {
        if (!this.accepted && !this.outBinary | (this.outBinary && this.sendingBinary) && !this.inBinary | (this.inBinary && this.receivingBinary)) {
            this.accepted = true;
            this.readBuffer.setReadHandler(this.eventDecoder);
            this.handler.accept(this);
        }
    }

    @Override
    protected void onTerminalType(String terminalType) {
        this.terminalType = terminalType;
        if (this.termHandler != null) {
            this.termHandler.accept(terminalType);
        }
    }

    @Override
    public Vector size() {
        return this.size;
    }

    @Override
    protected void onSize(int width, int height) {
        this.size = new Vector(width, height);
        if (this.sizeHandler != null) {
            this.sizeHandler.accept(this.size);
        }
    }

    @Override
    public Consumer<Vector> getSizeHandler() {
        return this.sizeHandler;
    }

    @Override
    public void setSizeHandler(Consumer<Vector> handler) {
        this.sizeHandler = handler;
    }

    @Override
    public Consumer<String> getTerminalTypeHandler() {
        return this.termHandler;
    }

    @Override
    public void setTerminalTypeHandler(Consumer<String> handler) {
        this.termHandler = handler;
        if (handler != null && this.terminalType != null) {
            handler.accept(this.terminalType);
        }
    }

    @Override
    public BiConsumer<TtyEvent, Integer> getEventHandler() {
        return this.eventDecoder.getEventHandler();
    }

    @Override
    public void setEventHandler(BiConsumer<TtyEvent, Integer> handler) {
        this.eventDecoder.setEventHandler(handler);
    }

    @Override
    public Consumer<int[]> getStdinHandler() {
        return this.eventDecoder.getReadHandler();
    }

    @Override
    public void setStdinHandler(Consumer<int[]> handler) {
        this.eventDecoder.setReadHandler(handler);
    }

    @Override
    public Consumer<int[]> stdoutHandler() {
        return this.stdout;
    }

    @Override
    public void setCloseHandler(Consumer<Void> closeHandler) {
        this.closeHandler = closeHandler;
    }

    @Override
    public Consumer<Void> getCloseHandler() {
        return this.closeHandler;
    }

    @Override
    protected void onClose() {
        if (this.closeHandler != null) {
            this.closeHandler.accept(null);
        }
    }

    @Override
    public void close() {
        this.conn.close();
    }

    @Override
    public void close(int exit) {
        this.close();
    }

    @Override
    public TtyConnection write(String s2) {
        int[] codePoints = Helper.toCodePoints(s2);
        this.stdoutHandler().accept(codePoints);
        return this;
    }

    public TelnetConnection getTelnetConnection() {
        return this.conn;
    }
}

