/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text.ui;

import com.taobao.text.LineReader;
import com.taobao.text.RenderAppendable;
import com.taobao.text.ui.BorderStyle;
import com.taobao.text.ui.Overflow;
import com.taobao.text.ui.RowLineRenderer;
import com.taobao.text.ui.TableRowLineRenderer;

class TableRowReader
implements LineReader {
    private final TableRowLineRenderer renderer;
    private final int[] widths;
    private final RowLineRenderer row;
    private LineReader reader;
    private TableRowReader previous;
    private TableRowReader next;
    private BorderStyle top;
    private BorderStyle bottom;
    private final int height;
    private int status;

    TableRowReader(TableRowLineRenderer renderer, RowLineRenderer row, int[] widths, int height) {
        this.renderer = renderer;
        this.row = row;
        this.widths = widths;
        this.reader = null;
        this.top = null;
        this.bottom = null;
        this.height = height;
        this.status = 1;
    }

    TableRowReader add(TableRowReader next) {
        next.previous = this;
        this.next = next;
        BorderStyle borderStyle = this.renderer.header ? (this.renderer.table.separator != null ? this.renderer.table.separator : BorderStyle.DASHED) : (this.bottom = null);
        next.top = next.renderer.header && !this.renderer.header ? (next.renderer.table.separator != null ? next.renderer.table.separator : BorderStyle.DASHED) : null;
        next.status = next.top != null ? 0 : 1;
        return next;
    }

    TableRowReader previous() {
        return this.previous;
    }

    TableRowReader next() {
        return this.next;
    }

    boolean hasTop() {
        return this.renderer.header && this.previous != null;
    }

    boolean hasBottom() {
        return this.renderer.header && this.next != null && !this.next.renderer.header;
    }

    boolean isSeparator() {
        return this.status == 0 || this.status == 2;
    }

    @Override
    public boolean hasLine() {
        return 0 <= this.status && this.status <= 2;
    }

    @Override
    public void renderLine(RenderAppendable to) throws IllegalStateException {
        if (!this.hasLine()) {
            throw new IllegalStateException();
        }
        switch (this.status) {
            case 0: 
            case 2: {
                BorderStyle b = this.status == 0 ? this.top : this.bottom;
                to.styleOff();
                for (int i = 0; i < this.widths.length; ++i) {
                    if (i > 0 && this.renderer.table.separator != null) {
                        to.append(b.horizontal);
                    }
                    for (int j = 0; j < this.widths[i]; ++j) {
                        to.append(b.horizontal);
                    }
                }
                to.styleOn();
                ++this.status;
                break;
            }
            case 1: {
                if (this.reader == null) {
                    if (this.height > 0 && this.renderer.table.overflow == Overflow.WRAP) {
                        int h2 = this.height;
                        if (this.hasTop()) {
                            --h2;
                        }
                        if (this.hasBottom()) {
                            --h2;
                        }
                        this.reader = this.row.renderer(this.widths, h2);
                    } else {
                        this.reader = this.row.renderer(this.widths, -1);
                    }
                }
                this.reader.renderLine(to);
                if (this.renderer.table.overflow == Overflow.HIDDEN) {
                    this.status = this.bottom != null ? 2 : 3;
                    break;
                }
                if (this.reader.hasLine()) break;
                this.status = this.bottom != null ? 2 : 3;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }
}

