/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.util;

import java.util.Collection;
import java.util.Map;

public final class Utils {
    public static boolean hasText(String str) {
        return str != null && !str.trim().isEmpty();
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isAssignable(Class<?> targetType, Class<?> sourceType) {
        if (targetType == null || sourceType == null) {
            return false;
        }
        if (targetType.equals(sourceType)) {
            return true;
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        if (targetType.isPrimitive()) {
            Class<?> resolvedPrimitive = Utils.getPrimitiveClassForWrapper(sourceType);
            return resolvedPrimitive != null && targetType.equals(resolvedPrimitive);
        }
        if (sourceType.isPrimitive()) {
            Class<?> resolvedWrapper = Utils.getWrapperClassForPrimitive(sourceType);
            return resolvedWrapper != null && targetType.equals(resolvedWrapper);
        }
        return false;
    }

    public static Class<?> getPrimitiveClassForWrapper(Class<?> wrapperClass) {
        if (Boolean.class.equals(wrapperClass)) {
            return Boolean.TYPE;
        }
        if (Byte.class.equals(wrapperClass)) {
            return Byte.TYPE;
        }
        if (Character.class.equals(wrapperClass)) {
            return Character.TYPE;
        }
        if (Double.class.equals(wrapperClass)) {
            return Double.TYPE;
        }
        if (Float.class.equals(wrapperClass)) {
            return Float.TYPE;
        }
        if (Integer.class.equals(wrapperClass)) {
            return Integer.TYPE;
        }
        if (Long.class.equals(wrapperClass)) {
            return Long.TYPE;
        }
        if (Short.class.equals(wrapperClass)) {
            return Short.TYPE;
        }
        if (Void.class.equals(wrapperClass)) {
            return Void.TYPE;
        }
        return null;
    }

    public static Class<?> getWrapperClassForPrimitive(Class<?> primitiveClass) {
        if (Boolean.TYPE.equals(primitiveClass)) {
            return Boolean.class;
        }
        if (Byte.TYPE.equals(primitiveClass)) {
            return Byte.class;
        }
        if (Character.TYPE.equals(primitiveClass)) {
            return Character.class;
        }
        if (Double.TYPE.equals(primitiveClass)) {
            return Double.class;
        }
        if (Float.TYPE.equals(primitiveClass)) {
            return Float.class;
        }
        if (Integer.TYPE.equals(primitiveClass)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(primitiveClass)) {
            return Long.class;
        }
        if (Short.TYPE.equals(primitiveClass)) {
            return Short.class;
        }
        if (Void.TYPE.equals(primitiveClass)) {
            return Void.class;
        }
        return null;
    }
}

