/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.protocol.server.transport;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.taobao.arthas.mcp.server.protocol.server.McpTransportContextExtractor;
import com.taobao.arthas.mcp.server.protocol.server.handler.McpStreamableHttpRequestHandler;
import com.taobao.arthas.mcp.server.protocol.spec.McpStreamableServerSession;
import com.taobao.arthas.mcp.server.protocol.spec.McpStreamableServerTransportProvider;
import com.taobao.arthas.mcp.server.util.Assert;
import io.netty.handler.codec.http.FullHttpRequest;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class NettyStreamableServerTransportProvider
implements McpStreamableServerTransportProvider {
    private final McpStreamableHttpRequestHandler requestHandler;

    private NettyStreamableServerTransportProvider(ObjectMapper objectMapper, String mcpEndpoint, boolean disallowDelete, McpTransportContextExtractor<FullHttpRequest> contextExtractor, Duration keepAliveInterval) {
        Assert.notNull(objectMapper, "ObjectMapper must not be null");
        Assert.notNull(mcpEndpoint, "MCP endpoint must not be null");
        Assert.notNull(contextExtractor, "Context extractor must not be null");
        this.requestHandler = new McpStreamableHttpRequestHandler(objectMapper, mcpEndpoint, disallowDelete, contextExtractor, keepAliveInterval);
    }

    @Override
    public String protocolVersion() {
        return "2025-03-26";
    }

    @Override
    public void setSessionFactory(McpStreamableServerSession.Factory sessionFactory) {
        this.requestHandler.setSessionFactory(sessionFactory);
    }

    @Override
    public CompletableFuture<Void> notifyClients(String method, Object params) {
        return this.requestHandler.notifyClients(method, params);
    }

    @Override
    public CompletableFuture<Void> closeGracefully() {
        return this.requestHandler.closeGracefully();
    }

    @Override
    public McpStreamableHttpRequestHandler getMcpRequestHandler() {
        if (this.requestHandler != null) {
            return this.requestHandler;
        }
        throw new UnsupportedOperationException("Streamable transport provider does not support legacy SSE request handler");
    }

    public static Builder builder() {
        return new Builder();
    }

    private static interface KeepAliveScheduler {
        public void shutdown();
    }

    public static class Builder {
        private ObjectMapper objectMapper;
        private String mcpEndpoint = "/mcp";
        private boolean disallowDelete = false;
        private McpTransportContextExtractor<FullHttpRequest> contextExtractor = (serverRequest, context) -> context;
        private Duration keepAliveInterval;

        public Builder objectMapper(ObjectMapper objectMapper) {
            Assert.notNull(objectMapper, "ObjectMapper must not be null");
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder mcpEndpoint(String mcpEndpoint) {
            Assert.notNull(mcpEndpoint, "MCP endpoint must not be null");
            this.mcpEndpoint = mcpEndpoint;
            return this;
        }

        public Builder disallowDelete(boolean disallowDelete) {
            this.disallowDelete = disallowDelete;
            return this;
        }

        public Builder contextExtractor(McpTransportContextExtractor<FullHttpRequest> contextExtractor) {
            Assert.notNull(contextExtractor, "Context extractor must not be null");
            this.contextExtractor = contextExtractor;
            return this;
        }

        public Builder keepAliveInterval(Duration keepAliveInterval) {
            this.keepAliveInterval = keepAliveInterval;
            return this;
        }

        public NettyStreamableServerTransportProvider build() {
            Assert.notNull(this.objectMapper, "ObjectMapper must be set");
            Assert.notNull(this.mcpEndpoint, "MCP endpoint must be set");
            return new NettyStreamableServerTransportProvider(this.objectMapper, this.mcpEndpoint, this.disallowDelete, this.contextExtractor, this.keepAliveInterval);
        }
    }
}

