/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.protocol.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.taobao.arthas.mcp.server.protocol.server.McpTransportContext;
import com.taobao.arthas.mcp.server.protocol.spec.McpError;
import com.taobao.arthas.mcp.server.protocol.spec.McpSchema;
import com.taobao.arthas.mcp.server.protocol.spec.McpSession;
import com.taobao.arthas.mcp.server.util.Assert;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpNettyServerExchange {
    private static final Logger logger = LoggerFactory.getLogger(McpNettyServerExchange.class);
    private final String sessionId;
    private final McpSession session;
    private final McpSchema.ClientCapabilities clientCapabilities;
    private final McpSchema.Implementation clientInfo;
    private final McpTransportContext transportContext;
    private volatile McpSchema.LoggingLevel minLoggingLevel = McpSchema.LoggingLevel.INFO;
    private static final TypeReference<McpSchema.CreateMessageResult> CREATE_MESSAGE_RESULT_TYPE_REF = new TypeReference<McpSchema.CreateMessageResult>(){};
    private static final TypeReference<McpSchema.ListRootsResult> LIST_ROOTS_RESULT_TYPE_REF = new TypeReference<McpSchema.ListRootsResult>(){};
    public static final TypeReference<Object> OBJECT_TYPE_REF = new TypeReference<Object>(){};

    public McpNettyServerExchange(String sessionId, McpSession session, McpSchema.ClientCapabilities clientCapabilities, McpSchema.Implementation clientInfo, McpTransportContext transportContext) {
        this.sessionId = sessionId;
        this.session = session;
        this.clientCapabilities = clientCapabilities;
        this.clientInfo = clientInfo;
        this.transportContext = transportContext;
    }

    public McpSchema.ClientCapabilities getClientCapabilities() {
        return this.clientCapabilities;
    }

    public McpSchema.Implementation getClientInfo() {
        return this.clientInfo;
    }

    public McpSession getSession() {
        return this.session;
    }

    public CompletableFuture<McpSchema.CreateMessageResult> createMessage(McpSchema.CreateMessageRequest createMessageRequest) {
        if (this.clientCapabilities == null) {
            logger.error("Client not initialized, cannot create message");
            CompletableFuture<McpSchema.CreateMessageResult> future = new CompletableFuture<McpSchema.CreateMessageResult>();
            future.completeExceptionally(new McpError((Object)"Client must be initialized first. Please call initialize method!"));
            return future;
        }
        if (this.clientCapabilities.getSampling() == null) {
            logger.error("Client not configured with sampling capability, cannot create message");
            CompletableFuture<McpSchema.CreateMessageResult> future = new CompletableFuture<McpSchema.CreateMessageResult>();
            future.completeExceptionally(new McpError((Object)"Client must be configured with sampling capability"));
            return future;
        }
        logger.debug("Creating client message, session ID: {}", (Object)this.sessionId);
        return this.session.sendRequest("sampling/createMessage", createMessageRequest, CREATE_MESSAGE_RESULT_TYPE_REF).whenComplete((result, error) -> {
            if (error != null) {
                logger.error("Failed to create message, session ID: {}, error: {}", (Object)this.sessionId, (Object)error.getMessage());
            } else {
                logger.debug("Message created successfully, session ID: {}", (Object)this.sessionId);
            }
        });
    }

    public CompletableFuture<McpSchema.ListRootsResult> listRoots() {
        return this.listRoots(null);
    }

    public CompletableFuture<McpSchema.ListRootsResult> listRoots(String cursor) {
        logger.debug("Requesting root list, session ID: {}, cursor: {}", (Object)this.sessionId, (Object)cursor);
        return this.session.sendRequest("roots/list", new McpSchema.PaginatedRequest(cursor), LIST_ROOTS_RESULT_TYPE_REF).whenComplete((result, error) -> {
            if (error != null) {
                logger.error("Failed to get root list, session ID: {}, error: {}", (Object)this.sessionId, (Object)error.getMessage());
            } else {
                logger.debug("Root list retrieved successfully, session ID: {}", (Object)this.sessionId);
            }
        });
    }

    public CompletableFuture<Void> loggingNotification(McpSchema.LoggingMessageNotification loggingMessageNotification) {
        if (loggingMessageNotification == null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new McpError((Object)"\u65e5\u5fd7\u6d88\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
            return future;
        }
        if (this.isNotificationForLevelAllowed(loggingMessageNotification.getLevel())) {
            return this.session.sendNotification("notifications/message", loggingMessageNotification).whenComplete((result, error) -> {
                if (error != null) {
                    logger.error("Failed to send logging notification, level: {}, session ID: {}, error: {}", new Object[]{loggingMessageNotification.getLevel(), this.sessionId, error.getMessage()});
                }
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Object> ping() {
        return this.session.sendRequest("ping", null, OBJECT_TYPE_REF);
    }

    public void setMinLoggingLevel(McpSchema.LoggingLevel minLoggingLevel) {
        Assert.notNull((Object)minLoggingLevel, "\u6700\u4f4e\u65e5\u5fd7\u7ea7\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        logger.debug("Setting minimum logging level: {}, session ID: {}", (Object)minLoggingLevel, (Object)this.sessionId);
        this.minLoggingLevel = minLoggingLevel;
    }

    private boolean isNotificationForLevelAllowed(McpSchema.LoggingLevel loggingLevel) {
        return loggingLevel.level() >= this.minLoggingLevel.level();
    }

    public CompletableFuture<Void> progressNotification(McpSchema.ProgressNotification progressNotification) {
        if (progressNotification == null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new McpError((Object)"\u8fdb\u5ea6\u901a\u77e5\u4e0d\u80fd\u4e3a\u7a7a"));
            return future;
        }
        return this.session.sendNotification("notifications/progress", progressNotification).whenComplete((result, error) -> {
            if (error != null) {
                logger.error("Failed to send progress notification, session ID: {}, error: {}", (Object)this.sessionId, (Object)error.getMessage());
            } else {
                logger.debug("Progress notification sent successfully, session ID: {}", (Object)this.sessionId);
            }
        });
    }
}

