/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.util.FileUtils;
import com.taobao.arthas.core.util.LogUtil;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class ClassDumpTransformer
implements ClassFileTransformer {
    private static final Logger logger = LoggerFactory.getLogger(ClassDumpTransformer.class);
    private Set<Class<?>> classesToEnhance;
    private Map<Class<?>, File> dumpResult;
    private File arthasLogHome;
    private File directory;

    public ClassDumpTransformer(Set<Class<?>> classesToEnhance) {
        this(classesToEnhance, null);
    }

    public ClassDumpTransformer(Set<Class<?>> classesToEnhance, File directory) {
        this.classesToEnhance = classesToEnhance;
        this.dumpResult = new HashMap();
        this.arthasLogHome = new File(LogUtil.loggingDir());
        this.directory = directory;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (this.classesToEnhance.contains(classBeingRedefined)) {
            this.dumpClassIfNecessary(classBeingRedefined, classfileBuffer);
        }
        return null;
    }

    public Map<Class<?>, File> getDumpResult() {
        return this.dumpResult;
    }

    public File dumpDir() {
        String classDumpDir = "classdump";
        File dumpDir = this.directory != null ? this.directory : new File(this.arthasLogHome, classDumpDir);
        return dumpDir;
    }

    private void dumpClassIfNecessary(Class<?> clazz, byte[] data) {
        String className = clazz.getName();
        ClassLoader classLoader = clazz.getClassLoader();
        File dumpDir = this.dumpDir();
        if (!dumpDir.mkdirs() && !dumpDir.exists()) {
            logger.warn("create dump directory:{} failed.", (Object)dumpDir.getAbsolutePath());
            return;
        }
        String fileName = classLoader != null ? classLoader.getClass().getName() + "-" + Integer.toHexString(classLoader.hashCode()) + File.separator + className.replace(".", File.separator) + ".class" : className.replace(".", File.separator) + ".class";
        File dumpClassFile = new File(dumpDir, fileName);
        try {
            FileUtils.writeByteArrayToFile(dumpClassFile, data);
            this.dumpResult.put(clazz, dumpClassFile);
        }
        catch (IOException e) {
            logger.warn("dump class:{} to file {} failed.", className, dumpClassFile, e);
        }
    }
}

