/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReaderPrimitive;
import com.alibaba.fastjson2.util.Fnv;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Function;

final class ObjectReaderImplCharValueArray
extends ObjectReaderPrimitive {
    static final ObjectReaderImplCharValueArray INSTANCE = new ObjectReaderImplCharValueArray(null);
    static final long TYPE_HASH = Fnv.hashCode64("[C");
    final Function<char[], Object> builder;

    public ObjectReaderImplCharValueArray(Function<char[], Object> builder) {
        super(char[].class);
        this.builder = builder;
    }

    @Override
    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.readIfNull()) {
            return null;
        }
        if (jsonReader.current() == '\"') {
            String str = jsonReader.readString();
            char[] chars = str.toCharArray();
            if (this.builder != null) {
                return this.builder.apply(chars);
            }
            return chars;
        }
        if (jsonReader.nextIfArrayStart()) {
            char[] values2 = new char[16];
            int size = 0;
            while (!jsonReader.nextIfArrayEnd()) {
                int minCapacity = size + 1;
                if (minCapacity - values2.length > 0) {
                    int oldCapacity = values2.length;
                    int newCapacity = oldCapacity + (oldCapacity >> 1);
                    if (newCapacity - minCapacity < 0) {
                        newCapacity = minCapacity;
                    }
                    values2 = Arrays.copyOf(values2, newCapacity);
                }
                if (jsonReader.isInt()) {
                    values2[size++] = (char)jsonReader.readInt32Value();
                    continue;
                }
                String str = jsonReader.readString();
                values2[size++] = str == null ? (char)'\u0000' : str.charAt(0);
            }
            jsonReader.nextIfComma();
            char[] chars = Arrays.copyOf(values2, size);
            if (this.builder != null) {
                return this.builder.apply(chars);
            }
            return chars;
        }
        throw new JSONException(jsonReader.info("TODO"));
    }

    @Override
    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        long typeHashCode;
        if (jsonReader.nextIfMatch((byte)-110) && (typeHashCode = jsonReader.readTypeHashCode()) != TYPE_HASH) {
            throw new JSONException("not support autoType : " + jsonReader.getString());
        }
        if (jsonReader.isString()) {
            String str = jsonReader.readString();
            return str.toCharArray();
        }
        int entryCnt = jsonReader.startArray();
        if (entryCnt == -1) {
            return null;
        }
        char[] chars = new char[entryCnt];
        for (int i = 0; i < entryCnt; ++i) {
            chars[i] = jsonReader.isInt() ? (char)jsonReader.readInt32Value() : jsonReader.readString().charAt(0);
        }
        if (this.builder != null) {
            return this.builder.apply(chars);
        }
        return chars;
    }
}

