/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.utils;

import com.alibaba.deps.org.objectweb.asm.tree.AnnotationNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class AsmAnnotationUtils {
    public static <T> T queryAnnotationValue(List<AnnotationNode> annotations, String annotationType, String key) {
        if (annotations != null) {
            for (AnnotationNode annotationNode : annotations) {
                if (!annotationNode.desc.equals(annotationType) || annotationNode.values == null) continue;
                Iterator<Object> iterator2 = annotationNode.values.iterator();
                while (iterator2.hasNext()) {
                    String name = (String)iterator2.next();
                    Object value = iterator2.next();
                    if (!key.equals(name)) continue;
                    return (T)value;
                }
            }
        }
        return null;
    }

    public static <T> List<T> queryAnnotationValues(List<AnnotationNode> annotations, String annotationType, String key) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (annotations != null) {
            for (AnnotationNode annotationNode : annotations) {
                if (!annotationNode.desc.equals(annotationType) || annotationNode.values == null) continue;
                Iterator<Object> iterator2 = annotationNode.values.iterator();
                while (iterator2.hasNext()) {
                    String name = (String)iterator2.next();
                    Object values2 = iterator2.next();
                    if (!key.equals(name)) continue;
                    result.add(values2);
                }
            }
        }
        return result;
    }

    public static <T> List<T> queryAnnotationArrayValue(List<AnnotationNode> annotations, String annotationType, String key) {
        List result = (List)AsmAnnotationUtils.queryAnnotationValue(annotations, annotationType, key);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public static void addAnnotationInfo(List<AnnotationNode> annotations, String annotationType, String key, String value) {
        AnnotationNode annotationNode = null;
        for (AnnotationNode tmp : annotations) {
            if (!tmp.desc.equals(annotationType)) continue;
            annotationNode = tmp;
        }
        if (annotationNode == null) {
            annotationNode = new AnnotationNode(annotationType);
            annotations.add(annotationNode);
        }
        if (annotationNode.values == null) {
            annotationNode.values = new ArrayList<Object>();
        }
        Object name = null;
        List<String> values2 = null;
        Iterator<Object> iterator2 = annotationNode.values.iterator();
        while (iterator2.hasNext()) {
            if (key.equals(iterator2.next())) {
                values2 = (List)iterator2.next();
                continue;
            }
            iterator2.next();
        }
        if (values2 == null) {
            values2 = new ArrayList<String>();
            annotationNode.values.add(key);
            annotationNode.values.add(values2);
        }
        if (!values2.contains(values2)) {
            values2.add(value);
        }
    }
}

